/*
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
$(document).ready(function() {

    $(".click-title").mouseenter( function(    e){
        e.preventDefault();
        this.style.cursor="pointer";
    });
    $(".click-title").mousedown( function(event){
        event.preventDefault();
    });

    // Ugly code while this script is shared among several pages
    try{
        refreshHitsPerSecond(true);
    } catch(e){}
    try{
        refreshResponseTimeOverTime(true);
    } catch(e){}
    try{
        refreshResponseTimePercentiles();
    } catch(e){}
});


var responseTimePercentilesInfos = {
        data: {"result": {"minY": 7.0, "minX": 0.0, "maxY": 43488.0, "series": [{"data": [[0.0, 7.0], [0.1, 9.0], [0.2, 10.0], [0.3, 10.0], [0.4, 11.0], [0.5, 11.0], [0.6, 12.0], [0.7, 12.0], [0.8, 12.0], [0.9, 13.0], [1.0, 13.0], [1.1, 13.0], [1.2, 14.0], [1.3, 14.0], [1.4, 14.0], [1.5, 14.0], [1.6, 15.0], [1.7, 15.0], [1.8, 15.0], [1.9, 15.0], [2.0, 16.0], [2.1, 16.0], [2.2, 16.0], [2.3, 16.0], [2.4, 16.0], [2.5, 17.0], [2.6, 17.0], [2.7, 17.0], [2.8, 17.0], [2.9, 17.0], [3.0, 18.0], [3.1, 18.0], [3.2, 18.0], [3.3, 18.0], [3.4, 18.0], [3.5, 19.0], [3.6, 19.0], [3.7, 19.0], [3.8, 19.0], [3.9, 19.0], [4.0, 20.0], [4.1, 20.0], [4.2, 20.0], [4.3, 20.0], [4.4, 20.0], [4.5, 21.0], [4.6, 21.0], [4.7, 21.0], [4.8, 21.0], [4.9, 21.0], [5.0, 22.0], [5.1, 22.0], [5.2, 22.0], [5.3, 22.0], [5.4, 22.0], [5.5, 22.0], [5.6, 23.0], [5.7, 23.0], [5.8, 23.0], [5.9, 23.0], [6.0, 23.0], [6.1, 23.0], [6.2, 24.0], [6.3, 24.0], [6.4, 24.0], [6.5, 24.0], [6.6, 24.0], [6.7, 25.0], [6.8, 25.0], [6.9, 25.0], [7.0, 25.0], [7.1, 25.0], [7.2, 25.0], [7.3, 26.0], [7.4, 26.0], [7.5, 26.0], [7.6, 26.0], [7.7, 26.0], [7.8, 26.0], [7.9, 27.0], [8.0, 27.0], [8.1, 27.0], [8.2, 27.0], [8.3, 27.0], [8.4, 27.0], [8.5, 28.0], [8.6, 28.0], [8.7, 28.0], [8.8, 28.0], [8.9, 28.0], [9.0, 28.0], [9.1, 29.0], [9.2, 29.0], [9.3, 29.0], [9.4, 29.0], [9.5, 29.0], [9.6, 29.0], [9.7, 30.0], [9.8, 30.0], [9.9, 30.0], [10.0, 30.0], [10.1, 30.0], [10.2, 30.0], [10.3, 30.0], [10.4, 30.0], [10.5, 31.0], [10.6, 31.0], [10.7, 31.0], [10.8, 31.0], [10.9, 31.0], [11.0, 31.0], [11.1, 31.0], [11.2, 31.0], [11.3, 32.0], [11.4, 32.0], [11.5, 32.0], [11.6, 32.0], [11.7, 32.0], [11.8, 32.0], [11.9, 32.0], [12.0, 32.0], [12.1, 33.0], [12.2, 33.0], [12.3, 33.0], [12.4, 33.0], [12.5, 33.0], [12.6, 33.0], [12.7, 33.0], [12.8, 34.0], [12.9, 34.0], [13.0, 34.0], [13.1, 34.0], [13.2, 34.0], [13.3, 34.0], [13.4, 35.0], [13.5, 35.0], [13.6, 35.0], [13.7, 35.0], [13.8, 35.0], [13.9, 35.0], [14.0, 35.0], [14.1, 36.0], [14.2, 36.0], [14.3, 36.0], [14.4, 36.0], [14.5, 36.0], [14.6, 36.0], [14.7, 36.0], [14.8, 37.0], [14.9, 37.0], [15.0, 37.0], [15.1, 37.0], [15.2, 37.0], [15.3, 37.0], [15.4, 37.0], [15.5, 38.0], [15.6, 38.0], [15.7, 38.0], [15.8, 38.0], [15.9, 38.0], [16.0, 38.0], [16.1, 39.0], [16.2, 39.0], [16.3, 39.0], [16.4, 39.0], [16.5, 39.0], [16.6, 39.0], [16.7, 39.0], [16.8, 40.0], [16.9, 40.0], [17.0, 40.0], [17.1, 40.0], [17.2, 40.0], [17.3, 40.0], [17.4, 41.0], [17.5, 41.0], [17.6, 41.0], [17.7, 41.0], [17.8, 41.0], [17.9, 41.0], [18.0, 42.0], [18.1, 42.0], [18.2, 42.0], [18.3, 42.0], [18.4, 42.0], [18.5, 42.0], [18.6, 43.0], [18.7, 43.0], [18.8, 43.0], [18.9, 43.0], [19.0, 43.0], [19.1, 43.0], [19.2, 44.0], [19.3, 44.0], [19.4, 44.0], [19.5, 44.0], [19.6, 44.0], [19.7, 44.0], [19.8, 45.0], [19.9, 45.0], [20.0, 45.0], [20.1, 45.0], [20.2, 45.0], [20.3, 45.0], [20.4, 46.0], [20.5, 46.0], [20.6, 46.0], [20.7, 46.0], [20.8, 46.0], [20.9, 46.0], [21.0, 46.0], [21.1, 47.0], [21.2, 47.0], [21.3, 47.0], [21.4, 47.0], [21.5, 47.0], [21.6, 47.0], [21.7, 47.0], [21.8, 48.0], [21.9, 48.0], [22.0, 48.0], [22.1, 48.0], [22.2, 48.0], [22.3, 48.0], [22.4, 49.0], [22.5, 49.0], [22.6, 49.0], [22.7, 49.0], [22.8, 49.0], [22.9, 49.0], [23.0, 50.0], [23.1, 50.0], [23.2, 50.0], [23.3, 50.0], [23.4, 50.0], [23.5, 50.0], [23.6, 51.0], [23.7, 51.0], [23.8, 51.0], [23.9, 51.0], [24.0, 51.0], [24.1, 51.0], [24.2, 52.0], [24.3, 52.0], [24.4, 52.0], [24.5, 52.0], [24.6, 52.0], [24.7, 52.0], [24.8, 52.0], [24.9, 53.0], [25.0, 53.0], [25.1, 53.0], [25.2, 53.0], [25.3, 53.0], [25.4, 53.0], [25.5, 54.0], [25.6, 54.0], [25.7, 54.0], [25.8, 54.0], [25.9, 54.0], [26.0, 54.0], [26.1, 55.0], [26.2, 55.0], [26.3, 55.0], [26.4, 55.0], [26.5, 55.0], [26.6, 55.0], [26.7, 56.0], [26.8, 56.0], [26.9, 56.0], [27.0, 56.0], [27.1, 56.0], [27.2, 57.0], [27.3, 57.0], [27.4, 57.0], [27.5, 57.0], [27.6, 57.0], [27.7, 57.0], [27.8, 58.0], [27.9, 58.0], [28.0, 58.0], [28.1, 58.0], [28.2, 59.0], [28.3, 59.0], [28.4, 59.0], [28.5, 59.0], [28.6, 59.0], [28.7, 60.0], [28.8, 60.0], [28.9, 60.0], [29.0, 60.0], [29.1, 60.0], [29.2, 61.0], [29.3, 61.0], [29.4, 61.0], [29.5, 61.0], [29.6, 61.0], [29.7, 62.0], [29.8, 62.0], [29.9, 62.0], [30.0, 62.0], [30.1, 62.0], [30.2, 62.0], [30.3, 63.0], [30.4, 63.0], [30.5, 63.0], [30.6, 63.0], [30.7, 63.0], [30.8, 63.0], [30.9, 64.0], [31.0, 64.0], [31.1, 64.0], [31.2, 64.0], [31.3, 65.0], [31.4, 65.0], [31.5, 65.0], [31.6, 65.0], [31.7, 65.0], [31.8, 65.0], [31.9, 66.0], [32.0, 66.0], [32.1, 66.0], [32.2, 66.0], [32.3, 66.0], [32.4, 67.0], [32.5, 67.0], [32.6, 67.0], [32.7, 67.0], [32.8, 67.0], [32.9, 68.0], [33.0, 68.0], [33.1, 68.0], [33.2, 68.0], [33.3, 68.0], [33.4, 69.0], [33.5, 69.0], [33.6, 69.0], [33.7, 69.0], [33.8, 69.0], [33.9, 70.0], [34.0, 70.0], [34.1, 70.0], [34.2, 70.0], [34.3, 70.0], [34.4, 71.0], [34.5, 71.0], [34.6, 71.0], [34.7, 71.0], [34.8, 72.0], [34.9, 72.0], [35.0, 72.0], [35.1, 72.0], [35.2, 73.0], [35.3, 73.0], [35.4, 73.0], [35.5, 73.0], [35.6, 74.0], [35.7, 74.0], [35.8, 74.0], [35.9, 74.0], [36.0, 74.0], [36.1, 75.0], [36.2, 75.0], [36.3, 75.0], [36.4, 75.0], [36.5, 76.0], [36.6, 76.0], [36.7, 76.0], [36.8, 76.0], [36.9, 77.0], [37.0, 77.0], [37.1, 77.0], [37.2, 77.0], [37.3, 78.0], [37.4, 78.0], [37.5, 78.0], [37.6, 78.0], [37.7, 79.0], [37.8, 79.0], [37.9, 79.0], [38.0, 79.0], [38.1, 80.0], [38.2, 80.0], [38.3, 80.0], [38.4, 80.0], [38.5, 81.0], [38.6, 81.0], [38.7, 81.0], [38.8, 81.0], [38.9, 82.0], [39.0, 82.0], [39.1, 82.0], [39.2, 82.0], [39.3, 83.0], [39.4, 83.0], [39.5, 83.0], [39.6, 83.0], [39.7, 83.0], [39.8, 84.0], [39.9, 84.0], [40.0, 84.0], [40.1, 84.0], [40.2, 85.0], [40.3, 85.0], [40.4, 85.0], [40.5, 85.0], [40.6, 86.0], [40.7, 86.0], [40.8, 86.0], [40.9, 86.0], [41.0, 87.0], [41.1, 87.0], [41.2, 87.0], [41.3, 87.0], [41.4, 88.0], [41.5, 88.0], [41.6, 88.0], [41.7, 89.0], [41.8, 89.0], [41.9, 89.0], [42.0, 89.0], [42.1, 90.0], [42.2, 90.0], [42.3, 90.0], [42.4, 91.0], [42.5, 91.0], [42.6, 91.0], [42.7, 92.0], [42.8, 92.0], [42.9, 92.0], [43.0, 93.0], [43.1, 93.0], [43.2, 93.0], [43.3, 93.0], [43.4, 94.0], [43.5, 94.0], [43.6, 94.0], [43.7, 95.0], [43.8, 95.0], [43.9, 95.0], [44.0, 96.0], [44.1, 96.0], [44.2, 96.0], [44.3, 97.0], [44.4, 97.0], [44.5, 97.0], [44.6, 98.0], [44.7, 98.0], [44.8, 98.0], [44.9, 98.0], [45.0, 99.0], [45.1, 99.0], [45.2, 99.0], [45.3, 99.0], [45.4, 100.0], [45.5, 100.0], [45.6, 100.0], [45.7, 100.0], [45.8, 101.0], [45.9, 101.0], [46.0, 101.0], [46.1, 101.0], [46.2, 102.0], [46.3, 102.0], [46.4, 102.0], [46.5, 103.0], [46.6, 103.0], [46.7, 103.0], [46.8, 104.0], [46.9, 104.0], [47.0, 104.0], [47.1, 105.0], [47.2, 105.0], [47.3, 105.0], [47.4, 106.0], [47.5, 106.0], [47.6, 107.0], [47.7, 107.0], [47.8, 107.0], [47.9, 108.0], [48.0, 108.0], [48.1, 108.0], [48.2, 109.0], [48.3, 109.0], [48.4, 110.0], [48.5, 110.0], [48.6, 110.0], [48.7, 111.0], [48.8, 111.0], [48.9, 112.0], [49.0, 112.0], [49.1, 112.0], [49.2, 113.0], [49.3, 113.0], [49.4, 113.0], [49.5, 114.0], [49.6, 114.0], [49.7, 115.0], [49.8, 115.0], [49.9, 115.0], [50.0, 116.0], [50.1, 116.0], [50.2, 116.0], [50.3, 116.0], [50.4, 117.0], [50.5, 117.0], [50.6, 118.0], [50.7, 118.0], [50.8, 118.0], [50.9, 119.0], [51.0, 119.0], [51.1, 119.0], [51.2, 120.0], [51.3, 120.0], [51.4, 121.0], [51.5, 121.0], [51.6, 122.0], [51.7, 122.0], [51.8, 122.0], [51.9, 123.0], [52.0, 123.0], [52.1, 124.0], [52.2, 124.0], [52.3, 125.0], [52.4, 125.0], [52.5, 126.0], [52.6, 126.0], [52.7, 127.0], [52.8, 127.0], [52.9, 128.0], [53.0, 128.0], [53.1, 128.0], [53.2, 129.0], [53.3, 129.0], [53.4, 130.0], [53.5, 130.0], [53.6, 131.0], [53.7, 131.0], [53.8, 132.0], [53.9, 132.0], [54.0, 133.0], [54.1, 133.0], [54.2, 133.0], [54.3, 134.0], [54.4, 134.0], [54.5, 135.0], [54.6, 135.0], [54.7, 136.0], [54.8, 136.0], [54.9, 137.0], [55.0, 137.0], [55.1, 138.0], [55.2, 138.0], [55.3, 139.0], [55.4, 139.0], [55.5, 140.0], [55.6, 140.0], [55.7, 141.0], [55.8, 141.0], [55.9, 142.0], [56.0, 142.0], [56.1, 143.0], [56.2, 143.0], [56.3, 144.0], [56.4, 145.0], [56.5, 145.0], [56.6, 146.0], [56.7, 146.0], [56.8, 147.0], [56.9, 147.0], [57.0, 148.0], [57.1, 148.0], [57.2, 149.0], [57.3, 149.0], [57.4, 150.0], [57.5, 150.0], [57.6, 151.0], [57.7, 152.0], [57.8, 152.0], [57.9, 153.0], [58.0, 153.0], [58.1, 154.0], [58.2, 154.0], [58.3, 155.0], [58.4, 156.0], [58.5, 156.0], [58.6, 157.0], [58.7, 157.0], [58.8, 158.0], [58.9, 159.0], [59.0, 159.0], [59.1, 160.0], [59.2, 161.0], [59.3, 161.0], [59.4, 162.0], [59.5, 162.0], [59.6, 163.0], [59.7, 164.0], [59.8, 165.0], [59.9, 165.0], [60.0, 166.0], [60.1, 167.0], [60.2, 167.0], [60.3, 168.0], [60.4, 168.0], [60.5, 169.0], [60.6, 170.0], [60.7, 170.0], [60.8, 171.0], [60.9, 171.0], [61.0, 172.0], [61.1, 173.0], [61.2, 174.0], [61.3, 174.0], [61.4, 175.0], [61.5, 176.0], [61.6, 177.0], [61.7, 178.0], [61.8, 178.0], [61.9, 179.0], [62.0, 180.0], [62.1, 181.0], [62.2, 181.0], [62.3, 182.0], [62.4, 183.0], [62.5, 184.0], [62.6, 185.0], [62.7, 185.0], [62.8, 186.0], [62.9, 187.0], [63.0, 188.0], [63.1, 188.0], [63.2, 189.0], [63.3, 190.0], [63.4, 191.0], [63.5, 192.0], [63.6, 193.0], [63.7, 194.0], [63.8, 195.0], [63.9, 196.0], [64.0, 197.0], [64.1, 198.0], [64.2, 199.0], [64.3, 199.0], [64.4, 200.0], [64.5, 201.0], [64.6, 202.0], [64.7, 203.0], [64.8, 203.0], [64.9, 204.0], [65.0, 205.0], [65.1, 206.0], [65.2, 208.0], [65.3, 209.0], [65.4, 210.0], [65.5, 211.0], [65.6, 212.0], [65.7, 212.0], [65.8, 213.0], [65.9, 214.0], [66.0, 215.0], [66.1, 216.0], [66.2, 217.0], [66.3, 218.0], [66.4, 219.0], [66.5, 220.0], [66.6, 221.0], [66.7, 223.0], [66.8, 224.0], [66.9, 225.0], [67.0, 226.0], [67.1, 228.0], [67.2, 229.0], [67.3, 230.0], [67.4, 231.0], [67.5, 232.0], [67.6, 233.0], [67.7, 234.0], [67.8, 236.0], [67.9, 237.0], [68.0, 238.0], [68.1, 239.0], [68.2, 241.0], [68.3, 242.0], [68.4, 244.0], [68.5, 245.0], [68.6, 246.0], [68.7, 248.0], [68.8, 249.0], [68.9, 250.0], [69.0, 252.0], [69.1, 253.0], [69.2, 254.0], [69.3, 256.0], [69.4, 257.0], [69.5, 259.0], [69.6, 260.0], [69.7, 262.0], [69.8, 263.0], [69.9, 264.0], [70.0, 266.0], [70.1, 267.0], [70.2, 269.0], [70.3, 270.0], [70.4, 272.0], [70.5, 274.0], [70.6, 276.0], [70.7, 277.0], [70.8, 279.0], [70.9, 281.0], [71.0, 283.0], [71.1, 284.0], [71.2, 286.0], [71.3, 287.0], [71.4, 289.0], [71.5, 291.0], [71.6, 293.0], [71.7, 295.0], [71.8, 297.0], [71.9, 299.0], [72.0, 300.0], [72.1, 302.0], [72.2, 303.0], [72.3, 305.0], [72.4, 307.0], [72.5, 309.0], [72.6, 312.0], [72.7, 313.0], [72.8, 315.0], [72.9, 317.0], [73.0, 319.0], [73.1, 321.0], [73.2, 324.0], [73.3, 326.0], [73.4, 328.0], [73.5, 331.0], [73.6, 333.0], [73.7, 335.0], [73.8, 337.0], [73.9, 340.0], [74.0, 342.0], [74.1, 345.0], [74.2, 347.0], [74.3, 350.0], [74.4, 353.0], [74.5, 356.0], [74.6, 358.0], [74.7, 361.0], [74.8, 364.0], [74.9, 367.0], [75.0, 370.0], [75.1, 373.0], [75.2, 376.0], [75.3, 379.0], [75.4, 382.0], [75.5, 385.0], [75.6, 389.0], [75.7, 392.0], [75.8, 395.0], [75.9, 398.0], [76.0, 401.0], [76.1, 404.0], [76.2, 407.0], [76.3, 411.0], [76.4, 414.0], [76.5, 417.0], [76.6, 420.0], [76.7, 424.0], [76.8, 428.0], [76.9, 432.0], [77.0, 436.0], [77.1, 440.0], [77.2, 445.0], [77.3, 450.0], [77.4, 454.0], [77.5, 459.0], [77.6, 464.0], [77.7, 469.0], [77.8, 474.0], [77.9, 479.0], [78.0, 484.0], [78.1, 488.0], [78.2, 492.0], [78.3, 497.0], [78.4, 501.0], [78.5, 506.0], [78.6, 511.0], [78.7, 516.0], [78.8, 520.0], [78.9, 525.0], [79.0, 529.0], [79.1, 534.0], [79.2, 540.0], [79.3, 546.0], [79.4, 552.0], [79.5, 558.0], [79.6, 565.0], [79.7, 572.0], [79.8, 579.0], [79.9, 586.0], [80.0, 592.0], [80.1, 598.0], [80.2, 603.0], [80.3, 610.0], [80.4, 617.0], [80.5, 625.0], [80.6, 633.0], [80.7, 643.0], [80.8, 653.0], [80.9, 666.0], [81.0, 677.0], [81.1, 686.0], [81.2, 694.0], [81.3, 701.0], [81.4, 708.0], [81.5, 716.0], [81.6, 726.0], [81.7, 739.0], [81.8, 754.0], [81.9, 770.0], [82.0, 784.0], [82.1, 794.0], [82.2, 803.0], [82.3, 814.0], [82.4, 828.0], [82.5, 844.0], [82.6, 861.0], [82.7, 880.0], [82.8, 893.0], [82.9, 904.0], [83.0, 916.0], [83.1, 931.0], [83.2, 959.0], [83.3, 983.0], [83.4, 997.0], [83.5, 1007.0], [83.6, 1019.0], [83.7, 1033.0], [83.8, 1050.0], [83.9, 1073.0], [84.0, 1091.0], [84.1, 1105.0], [84.2, 1125.0], [84.3, 1173.0], [84.4, 1194.0], [84.5, 1208.0], [84.6, 1233.0], [84.7, 1284.0], [84.8, 1301.0], [84.9, 1318.0], [85.0, 1372.0], [85.1, 1396.0], [85.2, 1412.0], [85.3, 1463.0], [85.4, 1494.0], [85.5, 1510.0], [85.6, 1563.0], [85.7, 1594.0], [85.8, 1614.0], [85.9, 1674.0], [86.0, 1700.0], [86.1, 1728.0], [86.2, 1785.0], [86.3, 1814.0], [86.4, 1878.0], [86.5, 1905.0], [86.6, 1974.0], [86.7, 2008.0], [86.8, 2077.0], [86.9, 2111.0], [87.0, 2184.0], [87.1, 2235.0], [87.2, 2302.0], [87.3, 2387.0], [87.4, 2463.0], [87.5, 2523.0], [87.6, 2607.0], [87.7, 2696.0], [87.8, 2790.0], [87.9, 2880.0], [88.0, 2981.0], [88.1, 3086.0], [88.2, 3173.0], [88.3, 3269.0], [88.4, 3394.0], [88.5, 3511.0], [88.6, 3629.0], [88.7, 3733.0], [88.8, 3838.0], [88.9, 3947.0], [89.0, 4051.0], [89.1, 4160.0], [89.2, 4264.0], [89.3, 4362.0], [89.4, 4459.0], [89.5, 4541.0], [89.6, 4631.0], [89.7, 4719.0], [89.8, 4808.0], [89.9, 4898.0], [90.0, 4998.0], [90.1, 5092.0], [90.2, 5177.0], [90.3, 5262.0], [90.4, 5349.0], [90.5, 5431.0], [90.6, 5515.0], [90.7, 5584.0], [90.8, 5654.0], [90.9, 5720.0], [91.0, 5777.0], [91.1, 5830.0], [91.2, 5889.0], [91.3, 5946.0], [91.4, 6005.0], [91.5, 6057.0], [91.6, 6108.0], [91.7, 6160.0], [91.8, 6215.0], [91.9, 6263.0], [92.0, 6310.0], [92.1, 6352.0], [92.2, 6390.0], [92.3, 6432.0], [92.4, 6473.0], [92.5, 6513.0], [92.6, 6550.0], [92.7, 6587.0], [92.8, 6627.0], [92.9, 6664.0], [93.0, 6699.0], [93.1, 6741.0], [93.2, 6780.0], [93.3, 6822.0], [93.4, 6867.0], [93.5, 6910.0], [93.6, 6957.0], [93.7, 6995.0], [93.8, 7040.0], [93.9, 7086.0], [94.0, 7128.0], [94.1, 7171.0], [94.2, 7217.0], [94.3, 7256.0], [94.4, 7305.0], [94.5, 7355.0], [94.6, 7402.0], [94.7, 7454.0], [94.8, 7497.0], [94.9, 7542.0], [95.0, 7590.0], [95.1, 7638.0], [95.2, 7682.0], [95.3, 7726.0], [95.4, 7771.0], [95.5, 7814.0], [95.6, 7861.0], [95.7, 7906.0], [95.8, 7950.0], [95.9, 7988.0], [96.0, 8030.0], [96.1, 8071.0], [96.2, 8110.0], [96.3, 8151.0], [96.4, 8197.0], [96.5, 8238.0], [96.6, 8283.0], [96.7, 8336.0], [96.8, 8390.0], [96.9, 8445.0], [97.0, 8511.0], [97.1, 8582.0], [97.2, 8655.0], [97.3, 8736.0], [97.4, 8838.0], [97.5, 8941.0], [97.6, 9074.0], [97.7, 9227.0], [97.8, 9392.0], [97.9, 9610.0], [98.0, 9823.0], [98.1, 10092.0], [98.2, 10369.0], [98.3, 10681.0], [98.4, 11071.0], [98.5, 11490.0], [98.6, 12064.0], [98.7, 12815.0], [98.8, 13634.0], [98.9, 14879.0], [99.0, 16334.0], [99.1, 20839.0], [99.2, 21018.0], [99.3, 21023.0], [99.4, 21028.0], [99.5, 21036.0], [99.6, 23960.0], [99.7, 28134.0], [99.8, 30815.0], [99.9, 36333.0], [100.0, 43488.0]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "maxX": 100.0, "title": "Response Time Percentiles"}},
        getOptions: function() {
            return {
                series: {
                    points: { show: false }
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimePercentiles'
                },
                xaxis: {
                    tickDecimals: 1,
                    axisLabel: "Percentiles",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Percentile value in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : %x.2 percentile was %y ms"
                },
                selection: { mode: "xy" },
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesResponseTimePercentiles"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimesPercentiles"), dataset, options);
            // setup overview
            $.plot($("#overviewResponseTimesPercentiles"), dataset, prepareOverviewOptions(options));
        }
};

/**
 * @param elementId Id of element where we display message
 */
function setEmptyGraph(elementId) {
    $(function() {
        $(elementId).text("No graph series with filter="+seriesFilter);
    });
}

// Response times percentiles
function refreshResponseTimePercentiles() {
    var infos = responseTimePercentilesInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyResponseTimePercentiles");
        return;
    }
    if (isGraph($("#flotResponseTimesPercentiles"))){
        infos.createGraph();
    } else {
        var choiceContainer = $("#choicesResponseTimePercentiles");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimesPercentiles", "#overviewResponseTimesPercentiles");
        $('#bodyResponseTimePercentiles .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
}

var responseTimeDistributionInfos = {
        data: {"result": {"minY": 1.0, "minX": 0.0, "maxY": 84990.0, "series": [{"data": [[0.0, 84990.0], [100.0, 35635.0], [32900.0, 6.0], [33700.0, 3.0], [34500.0, 2.0], [35300.0, 2.0], [36100.0, 1.0], [37700.0, 3.0], [36900.0, 5.0], [38500.0, 8.0], [39300.0, 3.0], [40100.0, 5.0], [40900.0, 4.0], [41700.0, 1.0], [200.0, 14341.0], [300.0, 7474.0], [400.0, 4530.0], [500.0, 3307.0], [600.0, 2157.0], [700.0, 1663.0], [800.0, 1318.0], [900.0, 1061.0], [1000.0, 1165.0], [1100.0, 730.0], [1200.0, 664.0], [1300.0, 613.0], [1400.0, 581.0], [1500.0, 556.0], [1600.0, 510.0], [1700.0, 480.0], [1800.0, 420.0], [1900.0, 359.0], [2000.0, 365.0], [2100.0, 344.0], [2300.0, 253.0], [2200.0, 274.0], [2400.0, 258.0], [2500.0, 226.0], [2600.0, 221.0], [2700.0, 206.0], [2800.0, 202.0], [2900.0, 190.0], [3000.0, 187.0], [3100.0, 200.0], [3200.0, 172.0], [3300.0, 155.0], [3400.0, 163.0], [3500.0, 159.0], [3700.0, 182.0], [3600.0, 169.0], [3800.0, 178.0], [3900.0, 182.0], [4000.0, 167.0], [4100.0, 180.0], [4300.0, 194.0], [4200.0, 179.0], [4500.0, 212.0], [4400.0, 212.0], [4600.0, 221.0], [4700.0, 203.0], [4800.0, 206.0], [4900.0, 190.0], [5100.0, 208.0], [5000.0, 208.0], [5200.0, 221.0], [5300.0, 217.0], [5600.0, 285.0], [5500.0, 260.0], [5400.0, 230.0], [5800.0, 338.0], [5700.0, 315.0], [6000.0, 362.0], [6100.0, 350.0], [5900.0, 321.0], [6300.0, 461.0], [6200.0, 391.0], [6500.0, 494.0], [6400.0, 453.0], [6600.0, 509.0], [6800.0, 430.0], [6900.0, 436.0], [6700.0, 464.0], [7000.0, 417.0], [7100.0, 430.0], [7200.0, 426.0], [7300.0, 391.0], [7400.0, 396.0], [7500.0, 396.0], [7600.0, 409.0], [7900.0, 451.0], [7800.0, 419.0], [7700.0, 423.0], [8000.0, 463.0], [8100.0, 437.0], [8400.0, 317.0], [8600.0, 242.0], [8200.0, 425.0], [9200.0, 129.0], [8800.0, 189.0], [9000.0, 138.0], [9600.0, 101.0], [9400.0, 92.0], [10000.0, 77.0], [10200.0, 64.0], [9800.0, 60.0], [10400.0, 60.0], [10600.0, 55.0], [11200.0, 56.0], [11000.0, 56.0], [10800.0, 37.0], [11600.0, 43.0], [11400.0, 53.0], [12000.0, 35.0], [12200.0, 27.0], [11800.0, 29.0], [12600.0, 27.0], [12400.0, 21.0], [13000.0, 32.0], [12800.0, 35.0], [13200.0, 15.0], [13800.0, 19.0], [13600.0, 15.0], [13400.0, 20.0], [14000.0, 12.0], [14200.0, 8.0], [14400.0, 15.0], [14800.0, 17.0], [14600.0, 17.0], [15000.0, 13.0], [15200.0, 14.0], [15400.0, 16.0], [15600.0, 19.0], [15800.0, 12.0], [16200.0, 11.0], [16000.0, 12.0], [16800.0, 7.0], [16400.0, 9.0], [17200.0, 5.0], [17600.0, 9.0], [18400.0, 2.0], [18000.0, 1.0], [19200.0, 6.0], [18800.0, 3.0], [19600.0, 6.0], [20400.0, 7.0], [20000.0, 3.0], [21200.0, 2.0], [20800.0, 5.0], [21600.0, 5.0], [22400.0, 3.0], [22000.0, 2.0], [23200.0, 3.0], [22800.0, 1.0], [24000.0, 5.0], [24400.0, 3.0], [23600.0, 2.0], [24800.0, 7.0], [25200.0, 1.0], [26400.0, 3.0], [25600.0, 6.0], [26000.0, 3.0], [27600.0, 6.0], [26800.0, 8.0], [27200.0, 6.0], [28000.0, 10.0], [28400.0, 5.0], [29600.0, 5.0], [29200.0, 4.0], [28800.0, 6.0], [30400.0, 11.0], [30000.0, 6.0], [31200.0, 8.0], [30800.0, 12.0], [31600.0, 7.0], [32000.0, 6.0], [32400.0, 3.0], [32800.0, 4.0], [33600.0, 5.0], [34400.0, 3.0], [36800.0, 4.0], [35200.0, 1.0], [36000.0, 1.0], [38400.0, 11.0], [37600.0, 2.0], [39200.0, 6.0], [40000.0, 3.0], [40800.0, 1.0], [41600.0, 1.0], [33100.0, 1.0], [33900.0, 1.0], [34700.0, 3.0], [35500.0, 1.0], [36300.0, 4.0], [37100.0, 2.0], [37900.0, 4.0], [38700.0, 8.0], [39500.0, 6.0], [40300.0, 2.0], [16500.0, 3.0], [16900.0, 8.0], [17300.0, 8.0], [18100.0, 5.0], [17700.0, 5.0], [18900.0, 7.0], [19300.0, 2.0], [18500.0, 3.0], [20100.0, 1.0], [19700.0, 2.0], [20500.0, 1.0], [21300.0, 1.0], [22500.0, 5.0], [21700.0, 2.0], [22100.0, 1.0], [22900.0, 1.0], [23300.0, 1.0], [24500.0, 4.0], [24100.0, 3.0], [23700.0, 1.0], [25300.0, 3.0], [24900.0, 2.0], [26500.0, 5.0], [26100.0, 4.0], [25700.0, 2.0], [26900.0, 4.0], [27300.0, 2.0], [28100.0, 8.0], [28500.0, 7.0], [27700.0, 6.0], [28900.0, 5.0], [29300.0, 3.0], [30500.0, 6.0], [29700.0, 6.0], [30100.0, 7.0], [30900.0, 6.0], [31700.0, 9.0], [31300.0, 3.0], [32100.0, 4.0], [32500.0, 4.0], [33800.0, 4.0], [33000.0, 6.0], [34600.0, 3.0], [36200.0, 2.0], [35400.0, 3.0], [37800.0, 6.0], [37000.0, 2.0], [38600.0, 5.0], [39400.0, 3.0], [40200.0, 5.0], [41000.0, 1.0], [43400.0, 1.0], [34100.0, 2.0], [33300.0, 3.0], [34900.0, 3.0], [36500.0, 3.0], [35700.0, 2.0], [37300.0, 5.0], [38900.0, 5.0], [38100.0, 6.0], [40500.0, 1.0], [39700.0, 4.0], [41300.0, 1.0], [8300.0, 343.0], [8700.0, 198.0], [8500.0, 263.0], [9100.0, 118.0], [8900.0, 159.0], [9300.0, 97.0], [9700.0, 75.0], [9500.0, 84.0], [9900.0, 76.0], [10100.0, 68.0], [10700.0, 56.0], [10500.0, 56.0], [10300.0, 75.0], [11100.0, 34.0], [10900.0, 43.0], [11700.0, 31.0], [11300.0, 37.0], [11500.0, 34.0], [12100.0, 30.0], [11900.0, 19.0], [12700.0, 27.0], [12300.0, 19.0], [12500.0, 21.0], [13300.0, 20.0], [12900.0, 27.0], [13100.0, 26.0], [13700.0, 8.0], [13500.0, 16.0], [14300.0, 15.0], [13900.0, 16.0], [14100.0, 12.0], [14500.0, 23.0], [14700.0, 12.0], [14900.0, 11.0], [15100.0, 16.0], [15300.0, 18.0], [15700.0, 12.0], [15500.0, 16.0], [16100.0, 11.0], [15900.0, 4.0], [16300.0, 4.0], [16600.0, 6.0], [17000.0, 6.0], [17400.0, 3.0], [17800.0, 7.0], [18200.0, 5.0], [18600.0, 2.0], [19400.0, 2.0], [20200.0, 2.0], [20600.0, 5.0], [21000.0, 878.0], [21400.0, 4.0], [22200.0, 1.0], [21800.0, 1.0], [23400.0, 3.0], [22600.0, 2.0], [23000.0, 1.0], [23800.0, 1.0], [25400.0, 5.0], [25000.0, 2.0], [24600.0, 3.0], [25800.0, 4.0], [26200.0, 3.0], [26600.0, 6.0], [27000.0, 6.0], [27400.0, 8.0], [28600.0, 5.0], [27800.0, 12.0], [28200.0, 9.0], [29000.0, 7.0], [29400.0, 8.0], [30600.0, 10.0], [30200.0, 5.0], [29800.0, 14.0], [31000.0, 11.0], [31400.0, 3.0], [31800.0, 4.0], [32600.0, 1.0], [32200.0, 3.0], [34000.0, 2.0], [33200.0, 1.0], [34800.0, 1.0], [35600.0, 2.0], [36400.0, 2.0], [37200.0, 4.0], [38000.0, 2.0], [38800.0, 7.0], [39600.0, 2.0], [41200.0, 3.0], [33500.0, 3.0], [35100.0, 2.0], [36700.0, 5.0], [35900.0, 2.0], [38300.0, 6.0], [37500.0, 1.0], [39100.0, 8.0], [39900.0, 3.0], [16700.0, 8.0], [17100.0, 3.0], [17500.0, 3.0], [18300.0, 3.0], [17900.0, 4.0], [19100.0, 3.0], [18700.0, 4.0], [19500.0, 5.0], [19900.0, 5.0], [20300.0, 2.0], [21500.0, 3.0], [20700.0, 1.0], [21900.0, 2.0], [22300.0, 2.0], [23100.0, 3.0], [23500.0, 3.0], [22700.0, 1.0], [24300.0, 2.0], [23900.0, 2.0], [24700.0, 5.0], [25100.0, 2.0], [26300.0, 5.0], [25900.0, 3.0], [27100.0, 8.0], [27500.0, 5.0], [26700.0, 3.0], [27900.0, 7.0], [28300.0, 9.0], [28700.0, 7.0], [29100.0, 3.0], [29500.0, 5.0], [30700.0, 9.0], [30300.0, 10.0], [29900.0, 10.0], [31100.0, 6.0], [31500.0, 10.0], [32300.0, 3.0], [31900.0, 2.0], [32700.0, 1.0], [34200.0, 2.0], [35800.0, 4.0], [36600.0, 3.0], [35000.0, 2.0], [37400.0, 1.0], [38200.0, 1.0], [40600.0, 3.0], [39000.0, 6.0], [39800.0, 1.0]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 100, "maxX": 43400.0, "title": "Response Time Distribution"}},
        getOptions: function() {
            var granularity = this.data.result.granularity;
            return {
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimeDistribution'
                },
                xaxis:{
                    axisLabel: "Response times in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of responses",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                bars : {
                    show: true,
                    barWidth: this.data.result.granularity
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: function(label, xval, yval, flotItem){
                        return yval + " responses for " + label + " were between " + xval + " and " + (xval + granularity) + " ms";
                    }
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimeDistribution"), prepareData(data.result.series, $("#choicesResponseTimeDistribution")), options);
        }

};

// Response time distribution
function refreshResponseTimeDistribution() {
    var infos = responseTimeDistributionInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyResponseTimeDistribution");
        return;
    }
    if (isGraph($("#flotResponseTimeDistribution"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesResponseTimeDistribution");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        $('#footerResponseTimeDistribution .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};


var syntheticResponseTimeDistributionInfos = {
        data: {"result": {"minY": 1074.0, "minX": 0.0, "ticks": [[0, "Requests having \nresponse time <= 500ms"], [1, "Requests having \nresponse time > 500ms and <= 1,500ms"], [2, "Requests having \nresponse time > 1,500ms"], [3, "Requests in error"]], "maxY": 147022.0, "series": [{"data": [[0.0, 147022.0]], "color": "#9ACD32", "isOverall": false, "label": "Requests having \nresponse time <= 500ms", "isController": false}, {"data": [[1.0, 13023.0]], "color": "yellow", "isOverall": false, "label": "Requests having \nresponse time > 500ms and <= 1,500ms", "isController": false}, {"data": [[2.0, 26435.0]], "color": "orange", "isOverall": false, "label": "Requests having \nresponse time > 1,500ms", "isController": false}, {"data": [[3.0, 1074.0]], "color": "#FF6347", "isOverall": false, "label": "Requests in error", "isController": false}], "supportsControllersDiscrimination": false, "maxX": 3.0, "title": "Synthetic Response Times Distribution"}},
        getOptions: function() {
            return {
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendSyntheticResponseTimeDistribution'
                },
                xaxis:{
                    axisLabel: "Response times ranges",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                    tickLength:0,
                    min:-0.5,
                    max:3.5
                },
                yaxis: {
                    axisLabel: "Number of responses",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                bars : {
                    show: true,
                    align: "center",
                    barWidth: 0.25,
                    fill:.75
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: function(label, xval, yval, flotItem){
                        return yval + " " + label;
                    }
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var options = this.getOptions();
            prepareOptions(options, data);
            options.xaxis.ticks = data.result.ticks;
            $.plot($("#flotSyntheticResponseTimeDistribution"), prepareData(data.result.series, $("#choicesSyntheticResponseTimeDistribution")), options);
        }

};

// Response time distribution
function refreshSyntheticResponseTimeDistribution() {
    var infos = syntheticResponseTimeDistributionInfos;
    prepareSeries(infos.data, true);
    if (isGraph($("#flotSyntheticResponseTimeDistribution"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesSyntheticResponseTimeDistribution");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        $('#footerSyntheticResponseTimeDistribution .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var activeThreadsOverTimeInfos = {
        data: {"result": {"minY": 258.5976629502578, "minX": 1.68093552E12, "maxY": 1000.0, "series": [{"data": [[1.68093552E12, 258.5976629502578], [1.6809357E12, 1000.0], [1.68093558E12, 586.3748075146273], [1.68093576E12, 1000.0], [1.68093564E12, 943.0730954496523], [1.68093582E12, 966.6979820927427]], "isOverall": false, "label": "jp@gc - Ultimate Thread Group", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.68093582E12, "title": "Active Threads Over Time"}},
        getOptions: function() {
            return {
                series: {
                    stack: true,
                    lines: {
                        show: true,
                        fill: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of active threads",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 6,
                    show: true,
                    container: '#legendActiveThreadsOverTime'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                selection: {
                    mode: 'xy'
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : At %x there were %y active threads"
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesActiveThreadsOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotActiveThreadsOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewActiveThreadsOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Active Threads Over Time
function refreshActiveThreadsOverTime(fixTimestamps) {
    var infos = activeThreadsOverTimeInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotActiveThreadsOverTime"))) {
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesActiveThreadsOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotActiveThreadsOverTime", "#overviewActiveThreadsOverTime");
        $('#footerActiveThreadsOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var timeVsThreadsInfos = {
        data: {"result": {"minY": 11.0, "minX": 1.0, "maxY": 28242.8, "series": [{"data": [[3.0, 10695.0], [4.0, 11071.0], [5.0, 10166.0], [6.0, 11111.0], [11.0, 11084.6], [12.0, 3727.0], [13.0, 5162.0], [14.0, 930.0], [15.0, 1419.25], [16.0, 1066.4], [17.0, 1180.2222222222222], [18.0, 1042.4545454545453], [19.0, 910.2727272727273], [20.0, 75.0], [21.0, 24.857142857142858], [22.0, 94.6], [23.0, 14.75], [24.0, 889.9285714285714], [25.0, 1147.0], [26.0, 936.25], [27.0, 2098.4], [28.0, 107.83333333333333], [29.0, 1979.0], [30.0, 2952.818181818182], [31.0, 3743.0], [32.0, 883.1333333333333], [33.0, 25.5], [34.0, 1953.3636363636365], [35.0, 153.66666666666669], [37.0, 104.5], [36.0, 9792.0], [38.0, 247.4285714285714], [39.0, 39.666666666666664], [40.0, 2903.909090909091], [41.0, 2465.375], [42.0, 767.0555555555554], [43.0, 1448.4285714285713], [44.0, 1389.2222222222222], [45.0, 1225.75], [46.0, 245.0909090909091], [47.0, 1987.1], [48.0, 254.07142857142858], [49.0, 1092.7777777777778], [50.0, 256.85714285714283], [51.0, 19.166666666666668], [52.0, 1986.136363636364], [53.0, 16.4], [54.0, 257.8], [55.0, 3086.0], [56.0, 781.5], [57.0, 1612.1666666666667], [58.0, 1049.6000000000001], [59.0, 1934.6666666666667], [60.0, 758.95], [61.0, 3411.3333333333335], [62.0, 859.6315789473686], [63.0, 2144.8], [64.0, 653.5652173913044], [66.0, 836.375], [67.0, 1284.375], [65.0, 9604.0], [68.0, 1199.090909090909], [69.0, 2189.6], [70.0, 854.0555555555555], [71.0, 2423.75], [72.0, 332.7], [73.0, 1888.3333333333335], [74.0, 1278.0], [75.0, 5050.0], [76.0, 563.5454545454546], [77.0, 191.0], [78.0, 2281.3333333333335], [79.0, 3537.6666666666665], [80.0, 1210.2727272727273], [81.0, 1510.625], [82.0, 1333.818181818182], [83.0, 2089.6], [84.0, 928.9999999999999], [85.0, 5026.5], [86.0, 1067.9], [87.0, 1905.6666666666665], [88.0, 791.0000000000001], [90.0, 1898.8], [91.0, 1931.0], [92.0, 986.5625], [93.0, 224.0], [94.0, 1888.6153846153845], [95.0, 452.5], [96.0, 1132.4642857142856], [97.0, 2836.25], [98.0, 1117.25], [99.0, 2679.5], [100.0, 1113.25], [101.0, 3426.3333333333335], [102.0, 988.0], [103.0, 2766.75], [104.0, 511.0], [105.0, 2650.5555555555557], [106.0, 497.5769230769231], [108.0, 1672.608695652174], [109.0, 1963.2857142857142], [110.0, 1139.4615384615386], [111.0, 398.57142857142856], [112.0, 458.3478260869565], [113.0, 6349.2], [114.0, 2634.25], [115.0, 575.6666666666666], [116.0, 1586.4705882352941], [117.0, 2293.5], [118.0, 1144.8], [119.0, 2150.1666666666665], [120.0, 1533.8000000000002], [121.0, 3854.3333333333335], [122.0, 1049.8333333333333], [123.0, 9772.0], [124.0, 980.8235294117646], [125.0, 703.0], [126.0, 597.5333333333334], [127.0, 789.6], [128.0, 1420.392857142857], [129.0, 7567.5], [130.0, 887.8499999999999], [131.0, 5790.0], [132.0, 1263.0], [133.0, 2220.1428571428573], [134.0, 547.0454545454545], [135.0, 3431.4285714285716], [136.0, 805.0], [138.0, 698.0], [139.0, 3821.6666666666665], [140.0, 2267.8333333333335], [141.0, 1504.6363636363635], [142.0, 1183.2222222222222], [143.0, 1707.4444444444443], [137.0, 10372.5], [144.0, 768.8124999999999], [145.0, 3723.5], [146.0, 1484.909090909091], [147.0, 1808.4285714285716], [148.0, 2322.714285714286], [150.0, 1393.2916666666667], [151.0, 5065.5], [152.0, 1202.2631578947369], [153.0, 858.5], [154.0, 2077.9166666666665], [155.0, 2398.142857142857], [156.0, 1480.5294117647059], [157.0, 3088.25], [158.0, 1408.0588235294117], [159.0, 5219.5], [160.0, 1427.0625], [162.0, 1978.2857142857142], [163.0, 1011.2], [164.0, 1710.0], [165.0, 1732.5454545454545], [166.0, 1840.1], [167.0, 2614.8], [161.0, 9641.0], [168.0, 1111.1333333333334], [169.0, 2370.4], [170.0, 1320.5555555555557], [171.0, 1783.3], [172.0, 1298.3333333333333], [173.0, 2729.2], [174.0, 1497.4166666666667], [175.0, 2142.625], [176.0, 1066.2380952380952], [177.0, 3668.5], [178.0, 1113.1923076923076], [179.0, 2984.0], [180.0, 1132.304347826087], [181.0, 3576.3333333333335], [182.0, 1521.5454545454547], [183.0, 1979.375], [184.0, 1135.4545454545455], [185.0, 972.0666666666666], [190.0, 1270.8333333333333], [191.0, 635.0], [189.0, 9795.0], [188.0, 10131.0], [187.0, 9422.0], [186.0, 9611.0], [192.0, 1266.2619047619048], [193.0, 2677.2], [194.0, 1826.875], [195.0, 800.0], [196.0, 1980.9285714285716], [197.0, 1900.625], [198.0, 1247.8823529411766], [199.0, 9592.0], [200.0, 827.3], [201.0, 2339.909090909091], [202.0, 1318.72], [203.0, 2537.833333333333], [204.0, 1623.0], [205.0, 2081.285714285714], [206.0, 815.7272727272727], [207.0, 637.0], [208.0, 1350.0], [209.0, 4731.857142857143], [210.0, 949.84], [211.0, 3243.5], [212.0, 976.7934782608696], [214.0, 10427.0], [213.0, 9652.666666666666], [220.0, 1334.7894736842104], [221.0, 2205.8571428571427], [222.0, 1478.5], [223.0, 1668.5], [219.0, 8488.0], [218.0, 9406.5], [224.0, 1883.9411764705883], [225.0, 2498.666666666667], [226.0, 1153.25], [227.0, 3349.5], [228.0, 1421.5384615384614], [229.0, 1157.0], [230.0, 1194.3333333333333], [231.0, 3743.5], [232.0, 1664.3571428571431], [233.0, 1082.6666666666667], [234.0, 958.578947368421], [236.0, 2133.2333333333336], [237.0, 4024.0], [238.0, 1643.2631578947369], [239.0, 1050.0], [240.0, 2047.736842105263], [241.0, 4260.666666666666], [242.0, 1464.0], [243.0, 4234.4], [244.0, 2127.6], [245.0, 1233.375], [246.0, 2287.5714285714284], [247.0, 1328.5], [248.0, 1877.4], [249.0, 6403.0], [250.0, 1607.875], [251.0, 1238.75], [252.0, 1076.0000000000002], [253.0, 6762.25], [254.0, 1332.033333333333], [255.0, 2074.0], [259.0, 1612.5454545454545], [257.0, 4780.857142857142], [256.0, 839.0], [263.0, 10377.0], [258.0, 1312.8285714285716], [260.0, 1498.0588235294117], [262.0, 3765.4545454545455], [264.0, 1045.357142857143], [270.0, 2010.8235294117646], [271.0, 2741.2], [268.0, 1519.9411764705883], [269.0, 1303.888888888889], [265.0, 4105.833333333333], [266.0, 1405.2424242424242], [267.0, 8025.0], [273.0, 5003.0], [272.0, 1018.3600000000001], [274.0, 1847.25], [275.0, 2900.4], [276.0, 2457.4285714285716], [277.0, 3015.333333333333], [278.0, 1305.6363636363637], [279.0, 4988.6], [280.0, 1701.161290322581], [281.0, 8747.0], [286.0, 1052.7], [287.0, 3303.3333333333335], [284.0, 1896.8181818181815], [285.0, 3152.75], [282.0, 1752.769230769231], [283.0, 2375.875], [289.0, 3613.375], [288.0, 1984.888888888889], [290.0, 1365.782608695652], [291.0, 4121.0], [292.0, 1995.8275862068967], [293.0, 1533.0], [294.0, 1194.8823529411766], [295.0, 1343.6666666666667], [296.0, 1698.5833333333335], [297.0, 9144.0], [300.0, 1367.513222770062], [301.0, 9300.0], [303.0, 3749.8], [298.0, 2105.357142857143], [299.0, 1452.0], [316.0, 4984.5], [305.0, 4420.0], [304.0, 7763.0], [306.0, 2702.3333333333335], [307.0, 2895.6666666666665], [309.0, 4311.0], [308.0, 10153.0], [310.0, 10221.0], [311.0, 7680.0], [312.0, 4906.0], [315.0, 4643.0], [314.0, 9496.0], [313.0, 10005.0], [318.0, 3053.6666666666665], [317.0, 10280.0], [319.0, 2185.5], [321.0, 265.5], [320.0, 3340.3333333333335], [322.0, 15.5], [323.0, 6861.75], [324.0, 278.5], [325.0, 3006.5], [326.0, 15.25], [327.0, 3848.8], [328.0, 4707.0], [333.0, 4828.5], [332.0, 10407.0], [335.0, 9193.0], [334.0, 10372.0], [331.0, 11.0], [329.0, 8526.0], [350.0, 2903.6666666666665], [336.0, 4698.0], [338.0, 13.666666666666666], [337.0, 8252.0], [342.0, 271.5], [341.0, 8720.0], [340.0, 8224.0], [344.0, 6438.75], [345.0, 3308.0], [346.0, 3182.6666666666665], [347.0, 8893.0], [351.0, 8667.0], [349.0, 9412.5], [339.0, 8681.5], [354.0, 346.0], [353.0, 4604.0], [352.0, 9038.0], [355.0, 3433.6], [364.0, 4843.5], [366.0, 13.0], [367.0, 6876.0], [356.0, 4484.5], [357.0, 2312.75], [358.0, 2264.25], [359.0, 2864.3333333333335], [360.0, 4534.5], [361.0, 5459.5], [362.0, 5452.0], [363.0, 2144.25], [370.0, 2689.6666666666665], [369.0, 5883.666666666667], [371.0, 2100.25], [372.0, 14.0], [373.0, 3651.6], [374.0, 4440.0], [375.0, 8775.0], [376.0, 4781.5], [379.0, 15.0], [378.0, 8533.0], [377.0, 8280.0], [380.0, 5783.0], [382.0, 4463.0], [381.0, 7807.0], [383.0, 1405.8333333333333], [397.0, 2899.0], [386.0, 4220.0], [384.0, 348.3333333333333], [385.0, 8283.0], [389.0, 8669.0], [388.0, 9008.0], [392.0, 5280.4], [393.0, 2799.0], [396.0, 2356.5], [387.0, 7995.0], [399.0, 3456.6], [395.0, 9783.0], [394.0, 8731.0], [400.0, 3753.3333333333335], [404.0, 3399.3333333333335], [405.0, 4342.0], [407.0, 5760.0], [409.0, 5455.0], [411.0, 17.5], [410.0, 8620.0], [412.0, 1818.2], [403.0, 8747.0], [402.0, 8583.0], [401.0, 8780.0], [413.0, 3748.2], [414.0, 2655.0], [415.0, 5805.0], [418.0, 11.0], [417.0, 2228.75], [416.0, 8492.0], [419.0, 4423.5], [420.0, 3251.0], [421.0, 3199.3333333333335], [423.0, 4336.0], [422.0, 8377.0], [424.0, 12.0], [425.0, 8035.5], [427.0, 9167.0], [426.0, 8196.0], [428.0, 4966.5], [431.0, 4887.5], [430.0, 8260.0], [429.0, 8887.0], [434.0, 2138.25], [433.0, 4327.0], [432.0, 8429.0], [435.0, 530.0], [447.0, 12.333333333333334], [446.0, 8529.5], [436.0, 24.5], [437.0, 156.25], [438.0, 15.0], [439.0, 11.0], [442.0, 186.33333333333331], [443.0, 14.0], [448.0, 6114.666666666667], [451.0, 20.0], [450.0, 9947.0], [449.0, 9467.666666666666], [460.0, 2442.5], [462.0, 3131.0], [461.0, 8159.0], [463.0, 9636.0], [456.0, 9768.0], [452.0, 272.5], [453.0, 6791.25], [454.0, 4690.0], [455.0, 5103.0], [457.0, 1016.0], [458.0, 6618.0], [459.0, 4160.0], [465.0, 3093.3333333333335], [464.0, 2929.0], [467.0, 2977.3333333333335], [476.0, 16.0], [478.0, 3391.0], [477.0, 9224.5], [479.0, 3693.6666666666665], [468.0, 3053.3333333333335], [469.0, 5322.5], [470.0, 4448.0], [471.0, 3378.0], [472.0, 11.0], [473.0, 1006.0], [474.0, 6189.0], [475.0, 3545.5], [481.0, 14.333333333333334], [480.0, 14.666666666666666], [482.0, 3777.5], [483.0, 12.0], [484.0, 7201.166666666666], [485.0, 13.0], [487.0, 265.5], [488.0, 5646.666666666666], [495.0, 4543.0], [492.0, 514.0], [493.0, 3068.0], [489.0, 17.5], [491.0, 6611.75], [508.0, 2959.3333333333335], [497.0, 2641.3333333333335], [499.0, 2498.5], [498.0, 8365.0], [500.0, 2890.0], [501.0, 8471.0], [502.0, 2657.6666666666665], [503.0, 3919.0], [506.0, 4061.0], [504.0, 9273.0], [507.0, 6954.0], [510.0, 4372.5], [509.0, 9410.0], [511.0, 8364.0], [536.0, 19.5], [524.0, 10024.0], [513.0, 3886.0], [514.0, 2305.6666666666665], [517.0, 8851.0], [519.0, 9233.0], [518.0, 7398.0], [540.0, 3719.5], [539.0, 7980.5], [537.0, 8161.5], [541.0, 8633.0], [542.0, 520.0], [543.0, 2244.25], [528.0, 3441.3333333333335], [531.0, 1846.75], [530.0, 9227.0], [533.0, 7070.0], [534.0, 6209.0], [535.0, 3026.666666666667], [520.0, 6263.0], [521.0, 3695.5], [523.0, 518.0], [522.0, 9066.0], [525.0, 4616.0], [526.0, 1851.5], [527.0, 5501.25], [512.0, 8858.0], [560.0, 2663.0], [544.0, 12.0], [545.0, 8589.666666666666], [547.0, 5743.0], [551.0, 3916.5], [550.0, 8712.666666666666], [569.0, 728.2222222222223], [570.0, 2693.75], [571.0, 3477.0], [573.0, 24.5], [572.0, 7614.0], [574.0, 28242.8], [575.0, 13385.866666666665], [552.0, 2902.6666666666665], [556.0, 8894.666666666666], [553.0, 7750.0], [558.0, 7684.0], [557.0, 7590.0], [559.0, 7624.0], [562.0, 5217.0], [561.0, 7598.0], [563.0, 7362.0], [565.0, 4330.0], [564.0, 8563.0], [566.0, 3888.5], [567.0, 7515.0], [579.0, 3280.25], [576.0, 9640.0], [590.0, 1025.4285714285716], [591.0, 13472.714285714284], [588.0, 4598.0], [589.0, 3964.0], [586.0, 12.333333333333334], [587.0, 4804.6], [577.0, 8093.95], [578.0, 12374.153846153846], [580.0, 81.0], [581.0, 6131.7692307692305], [582.0, 11285.333333333334], [583.0, 14432.999999999996], [592.0, 42.666666666666664], [606.0, 1403.6666666666665], [607.0, 1207.0000000000002], [604.0, 3073.4], [605.0, 1064.375], [602.0, 17.0], [603.0, 1636.0], [600.0, 3485.130506690727], [601.0, 2743.3333333333335], [593.0, 8091.6], [594.0, 10430.0], [595.0, 10769.5], [596.0, 2784.0], [597.0, 6851.333333333333], [598.0, 14365.2], [599.0, 19552.312499999996], [584.0, 815.2222222222222], [585.0, 9927.384615384617], [611.0, 1242.2857142857142], [608.0, 811.1999999999999], [622.0, 1193.8333333333335], [623.0, 1031.0], [620.0, 1373.2727272727275], [621.0, 733.8999999999999], [618.0, 743.2], [619.0, 25.428571428571427], [609.0, 8361.8], [610.0, 805.0], [612.0, 44.77777777777778], [613.0, 1637.9], [614.0, 1069.625], [615.0, 1081.7142857142858], [624.0, 1157.75], [638.0, 13891.181818181818], [639.0, 5123.3], [636.0, 4914.444444444445], [637.0, 1424.6], [634.0, 1507.3333333333333], [635.0, 15.4], [632.0, 4245.625], [633.0, 1819.0], [625.0, 18.54545454545455], [626.0, 3600.4], [627.0, 1250.1666666666665], [628.0, 1090.0], [629.0, 2109.0], [630.0, 4646.5], [631.0, 965.8888888888889], [616.0, 1643.8], [617.0, 716.6363636363636], [643.0, 6240.214285714285], [640.0, 14833.833333333334], [654.0, 11966.6], [655.0, 4121.823529411765], [652.0, 5283.833333333334], [653.0, 26.833333333333336], [650.0, 28.1], [651.0, 12197.750000000002], [641.0, 10586.733333333332], [642.0, 28.071428571428566], [644.0, 2981.75], [645.0, 31.11764705882353], [646.0, 4736.666666666667], [647.0, 3733.368421052631], [656.0, 2805.4761904761904], [671.0, 8923.466666666665], [669.0, 11091.5], [670.0, 18566.542857142857], [667.0, 2441.8947368421054], [668.0, 88.42307692307693], [665.0, 1599.1000000000008], [666.0, 49.8], [657.0, 3473.3888888888887], [658.0, 13677.45833333333], [659.0, 8179.347826086957], [660.0, 11434.17142857143], [661.0, 39.93548387096775], [662.0, 4734.357142857143], [663.0, 5707.0], [648.0, 7181.4], [649.0, 2665.142857142857], [675.0, 4951.371428571429], [672.0, 6178.344827586207], [686.0, 5872.867924528302], [687.0, 3450.466666666667], [684.0, 11525.25641025641], [685.0, 5226.27906976744], [682.0, 6799.82142857143], [683.0, 6601.35294117647], [673.0, 7127.041666666667], [674.0, 11731.874999999998], [676.0, 4505.897959183674], [677.0, 270.58333333333337], [678.0, 3389.9999999999995], [679.0, 363.1714285714286], [688.0, 341.76], [702.0, 1916.6400000000006], [703.0, 2090.666666666667], [700.0, 2800.916666666667], [701.0, 2621.818181818182], [698.0, 1731.95], [699.0, 3998.6333333333328], [696.0, 3484.105263157897], [697.0, 427.6521739130435], [689.0, 5404.937500000001], [690.0, 3230.838709677418], [691.0, 5518.609756097562], [692.0, 4887.941176470587], [693.0, 4141.568627450981], [694.0, 5558.13043478261], [695.0, 4864.606060606061], [680.0, 6466.846153846153], [681.0, 3115.3250000000007], [707.0, 5881.384615384617], [704.0, 1133.8000000000002], [718.0, 6362.871794871794], [719.0, 1737.6428571428569], [716.0, 1896.8709677419354], [717.0, 3341.3333333333344], [714.0, 2614.028571428572], [715.0, 1748.1212121212125], [705.0, 2264.647058823529], [706.0, 2426.1515151515155], [708.0, 5661.333333333334], [709.0, 2180.2380952380954], [710.0, 5428.961538461538], [711.0, 1515.370370370371], [720.0, 506.9411764705882], [734.0, 3932.521739130434], [735.0, 5453.615384615385], [732.0, 3299.000000000001], [733.0, 1724.1081081081086], [730.0, 3690.7666666666664], [731.0, 2797.093749999999], [728.0, 373.6666666666667], [729.0, 1783.4666666666665], [721.0, 1003.3888888888891], [722.0, 537.3181818181818], [723.0, 1008.2812499999999], [724.0, 2961.5], [725.0, 2935.1538461538466], [726.0, 3889.6388888888896], [727.0, 2330.113636363637], [712.0, 392.59375], [713.0, 3975.5862068965516], [739.0, 5845.714285714285], [736.0, 3259.97619047619], [750.0, 3102.8157894736837], [751.0, 3524.7741935483864], [748.0, 3833.189189189189], [749.0, 3749.9444444444443], [746.0, 1828.8518518518515], [747.0, 3049.2432432432433], [737.0, 3117.3333333333326], [738.0, 6696.7631578947385], [740.0, 4610.4358974358975], [741.0, 1762.060606060606], [742.0, 1607.4827586206895], [743.0, 2574.7631578947376], [752.0, 2060.5405405405404], [766.0, 3878.275], [767.0, 3411.2500000000005], [764.0, 99.17500000000003], [765.0, 1276.0882352941176], [762.0, 369.3703703703704], [763.0, 334.3529411764706], [760.0, 10036.035714285714], [761.0, 433.20370370370364], [753.0, 1429.15], [754.0, 1337.8461538461538], [755.0, 333.3333333333333], [756.0, 2943.4333333333334], [757.0, 126.10714285714286], [758.0, 751.0312500000001], [759.0, 7750.678571428573], [744.0, 3828.3103448275865], [745.0, 2803.333333333334], [771.0, 2339.5000000000005], [768.0, 2762.1666666666665], [782.0, 749.578947368421], [783.0, 2083.4594594594596], [780.0, 656.3809523809523], [781.0, 419.9117647058823], [778.0, 1960.9062500000002], [779.0, 1442.3513513513512], [769.0, 1282.731707317073], [770.0, 1589.5500000000002], [772.0, 475.94444444444446], [773.0, 1013.3214285714283], [774.0, 1905.791666666667], [775.0, 5503.517241379311], [784.0, 415.6363636363636], [798.0, 490.33333333333337], [799.0, 609.2121212121212], [796.0, 941.7313432835823], [797.0, 591.8076923076923], [794.0, 1132.0526315789475], [795.0, 1595.571428571429], [792.0, 3983.9375], [793.0, 2251.5714285714284], [785.0, 2035.3076923076917], [786.0, 1466.2962962962965], [787.0, 413.80487804878044], [788.0, 1017.8571428571429], [789.0, 2074.1666666666665], [790.0, 4116.187499999999], [791.0, 3306.9523809523816], [776.0, 993.8235294117648], [777.0, 3645.24], [803.0, 345.34482758620686], [800.0, 718.44], [814.0, 1434.744186046512], [815.0, 1256.6296296296296], [812.0, 2675.0], [813.0, 1217.7500000000005], [810.0, 2371.6285714285714], [811.0, 1344.8292682926829], [801.0, 325.72727272727275], [802.0, 287.34375], [804.0, 139.63636363636363], [805.0, 423.8478260869565], [806.0, 301.0], [807.0, 382.7179487179486], [816.0, 1144.1333333333332], [830.0, 653.7037037037037], [831.0, 675.6944444444445], [828.0, 404.2307692307692], [829.0, 549.5853658536586], [826.0, 615.4358974358976], [827.0, 559.0645161290323], [824.0, 1478.7142857142856], [825.0, 101.63157894736841], [817.0, 1092.777777777778], [818.0, 925.7941176470589], [819.0, 1357.125], [820.0, 1183.2222222222222], [821.0, 1435.0000000000002], [822.0, 959.1914893617021], [823.0, 1054.3437500000005], [808.0, 341.2], [809.0, 2311.09375], [835.0, 581.4705882352941], [832.0, 1020.4347826086957], [846.0, 1988.4666666666665], [847.0, 969.1935483870967], [844.0, 739.2941176470591], [845.0, 1551.0454545454545], [842.0, 917.25], [843.0, 1626.5121951219512], [833.0, 1507.0000000000002], [834.0, 827.2187500000001], [836.0, 716.029411764706], [837.0, 611.1612903225806], [838.0, 1991.64], [839.0, 414.52000000000004], [848.0, 1002.833333333333], [862.0, 1063.676470588235], [863.0, 651.0882352941176], [860.0, 1283.421052631579], [861.0, 974.448275862069], [858.0, 1033.2727272727268], [859.0, 947.8333333333335], [856.0, 1461.865384615385], [857.0, 1389.255319148936], [849.0, 1237.8484848484843], [850.0, 1112.3421052631581], [851.0, 1225.1749999999997], [852.0, 798.9142857142856], [853.0, 782.590909090909], [854.0, 942.0], [855.0, 1284.964285714286], [840.0, 1798.416666666667], [841.0, 578.0270270270271], [867.0, 1253.64], [864.0, 109.54166666666669], [878.0, 426.1428571428572], [879.0, 278.13157894736844], [876.0, 416.37500000000006], [877.0, 247.5151515151515], [874.0, 573.9166666666666], [875.0, 1358.21875], [865.0, 986.7083333333337], [866.0, 408.59459459459475], [868.0, 1425.580645161291], [869.0, 474.0], [870.0, 1470.4722222222222], [871.0, 1542.8387096774193], [880.0, 168.20930232558143], [894.0, 985.7272727272726], [895.0, 1026.7234042553196], [892.0, 737.3589743589744], [893.0, 1343.3333333333335], [890.0, 2261.6578947368416], [891.0, 1347.1363636363635], [888.0, 1043.2727272727273], [889.0, 1938.2083333333333], [881.0, 298.8636363636364], [882.0, 296.9], [883.0, 1380.4102564102566], [884.0, 1664.472222222222], [885.0, 1123.659090909091], [886.0, 1292.8409090909088], [887.0, 1682.4857142857147], [872.0, 1245.8000000000002], [873.0, 872.0357142857143], [899.0, 343.6304347826087], [896.0, 771.3928571428571], [910.0, 242.8275862068965], [911.0, 207.49999999999997], [908.0, 346.3714285714286], [909.0, 294.8571428571429], [906.0, 1572.4827586206893], [907.0, 319.50000000000006], [897.0, 639.8163265306122], [898.0, 205.15000000000003], [900.0, 1397.0384615384614], [901.0, 190.99999999999997], [902.0, 873.7073170731708], [903.0, 527.4883720930233], [912.0, 205.07407407407405], [926.0, 1126.0285714285715], [927.0, 1397.2307692307688], [924.0, 1387.3666666666668], [925.0, 1776.225806451613], [922.0, 480.39024390243924], [923.0, 509.69444444444446], [920.0, 372.96], [921.0, 348.1724137931035], [913.0, 925.0833333333331], [914.0, 829.96], [915.0, 479.9999999999999], [916.0, 1967.9999999999998], [917.0, 632.5499999999997], [918.0, 867.1351351351353], [919.0, 358.8571428571429], [904.0, 374.7352941176471], [905.0, 457.1874999999999], [931.0, 1329.3823529411764], [928.0, 1875.5357142857144], [942.0, 772.9999999999999], [943.0, 1260.290322580645], [940.0, 952.6071428571427], [941.0, 1044.3720930232555], [938.0, 667.9250000000001], [939.0, 776.232558139535], [929.0, 2178.8695652173915], [930.0, 1622.7105263157896], [932.0, 1454.31746031746], [933.0, 1580.7692307692307], [934.0, 851.0689655172414], [935.0, 415.49999999999994], [944.0, 768.040816326531], [958.0, 626.0869565217391], [959.0, 755.8499999999997], [956.0, 577.4666666666666], [957.0, 621.9787234042554], [954.0, 817.8780487804877], [955.0, 927.7234042553195], [952.0, 570.5714285714288], [953.0, 942.8499999999998], [945.0, 1072.4814814814815], [946.0, 1689.1290322580649], [947.0, 1416.28], [948.0, 755.0999999999999], [949.0, 1168.98], [950.0, 531.7428571428572], [951.0, 768.6000000000001], [936.0, 681.051282051282], [937.0, 586.5454545454545], [963.0, 905.2340425531914], [960.0, 1886.0344827586207], [974.0, 2026.0689655172416], [975.0, 605.2380952380954], [972.0, 175.54545454545456], [973.0, 1313.166666666667], [970.0, 978.5263157894739], [971.0, 962.225806451613], [961.0, 199.5], [962.0, 1164.9142857142856], [964.0, 887.413043478261], [965.0, 1043.7894736842106], [966.0, 1738.8918918918919], [967.0, 1801.3599999999997], [976.0, 204.33333333333334], [990.0, 885.820512820513], [991.0, 769.76], [988.0, 1076.8235294117646], [989.0, 834.1176470588234], [986.0, 1204.2424242424245], [987.0, 659.6744186046512], [984.0, 259.3333333333333], [985.0, 449.40000000000003], [977.0, 204.0625], [978.0, 175.45714285714286], [979.0, 233.0666666666666], [980.0, 289.5], [981.0, 310.4166666666667], [982.0, 443.6296296296296], [983.0, 271.8048780487805], [968.0, 768.9390243902436], [969.0, 509.65217391304355], [995.0, 438.0454545454545], [992.0, 341.6944444444444], [993.0, 1091.32], [994.0, 1052.7894736842104], [996.0, 881.1250000000003], [997.0, 1273.7692307692307], [998.0, 1132.5714285714284], [999.0, 342.6], [1000.0, 1042.9388363525848], [1.0, 10303.0]], "isOverall": false, "label": "HTTP Request", "isController": false}, {"data": [[933.1668959339581, 1231.2607142476193]], "isOverall": false, "label": "HTTP Request-Aggregated", "isController": false}], "supportsControllersDiscrimination": true, "maxX": 1000.0, "title": "Time VS Threads"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    axisLabel: "Number of active threads",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average response times in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: { noColumns: 2,show: true, container: '#legendTimeVsThreads' },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s: At %x.2 active threads, Average response time was %y.2 ms"
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesTimeVsThreads"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotTimesVsThreads"), dataset, options);
            // setup overview
            $.plot($("#overviewTimesVsThreads"), dataset, prepareOverviewOptions(options));
        }
};

// Time vs threads
function refreshTimeVsThreads(){
    var infos = timeVsThreadsInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyTimeVsThreads");
        return;
    }
    if(isGraph($("#flotTimesVsThreads"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesTimeVsThreads");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotTimesVsThreads", "#overviewTimesVsThreads");
        $('#footerTimeVsThreads .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var bytesThroughputOverTimeInfos = {
        data : {"result": {"minY": 16010.0, "minX": 1.68093552E12, "maxY": 179880.1, "series": [{"data": [[1.68093552E12, 30381.066666666666], [1.6809357E12, 179880.1], [1.68093558E12, 21723.433333333334], [1.68093576E12, 159668.7], [1.68093564E12, 132308.23333333334], [1.68093582E12, 41655.36666666667]], "isOverall": false, "label": "Bytes received per second", "isController": false}, {"data": [[1.68093552E12, 23047.5], [1.6809357E12, 140215.0], [1.68093558E12, 16010.0], [1.68093576E12, 143415.0], [1.68093564E12, 106097.5], [1.68093582E12, 37415.0]], "isOverall": false, "label": "Bytes sent per second", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.68093582E12, "title": "Bytes Throughput Over Time"}},
        getOptions : function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity) ,
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Bytes / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendBytesThroughputOverTime'
                },
                selection: {
                    mode: "xy"
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y"
                }
            };
        },
        createGraph : function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesBytesThroughputOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotBytesThroughputOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewBytesThroughputOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Bytes throughput Over Time
function refreshBytesThroughputOverTime(fixTimestamps) {
    var infos = bytesThroughputOverTimeInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotBytesThroughputOverTime"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesBytesThroughputOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotBytesThroughputOverTime", "#overviewBytesThroughputOverTime");
        $('#footerBytesThroughputOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
}

var responseTimesOverTimeInfos = {
        data: {"result": {"minY": 1062.7993236411894, "minX": 1.68093552E12, "maxY": 3719.184170003073, "series": [{"data": [[1.68093552E12, 1177.7883790737546], [1.6809357E12, 1089.5581982554752], [1.68093558E12, 3719.184170003073], [1.68093576E12, 1062.7993236411894], [1.68093564E12, 1227.1149511294043], [1.68093582E12, 1378.8385006013652]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.68093582E12, "title": "Response Time Over Time"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average response time in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimesOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Average response time was %y ms"
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesResponseTimesOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimesOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewResponseTimesOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Response Times Over Time
function refreshResponseTimeOverTime(fixTimestamps) {
    var infos = responseTimesOverTimeInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyResponseTimeOverTime");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotResponseTimesOverTime"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesResponseTimesOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimesOverTime", "#overviewResponseTimesOverTime");
        $('#footerResponseTimesOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var latenciesOverTimeInfos = {
        data: {"result": {"minY": 886.0767030405781, "minX": 1.68093552E12, "maxY": 3691.8801971050293, "series": [{"data": [[1.68093552E12, 1165.666809605497], [1.6809357E12, 886.0767030405781], [1.68093558E12, 3691.8801971050293], [1.68093576E12, 1062.7749538053793], [1.68093564E12, 1066.3370200626678], [1.68093582E12, 1378.8154483495923]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.68093582E12, "title": "Latencies Over Time"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average response latencies in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendLatenciesOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Average latency was %y ms"
                }
            };
        },
        createGraph: function () {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesLatenciesOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotLatenciesOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewLatenciesOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Latencies Over Time
function refreshLatenciesOverTime(fixTimestamps) {
    var infos = latenciesOverTimeInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyLatenciesOverTime");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotLatenciesOverTime"))) {
        infos.createGraph();
    }else {
        var choiceContainer = $("#choicesLatenciesOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotLatenciesOverTime", "#overviewLatenciesOverTime");
        $('#footerLatenciesOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var connectTimeOverTimeInfos = {
        data: {"result": {"minY": 14.544166778030206, "minX": 1.68093552E12, "maxY": 341.2092082495462, "series": [{"data": [[1.68093552E12, 99.49603344768445], [1.6809357E12, 340.73710138785987], [1.68093558E12, 125.96519864490298], [1.68093576E12, 22.534776696998268], [1.68093564E12, 341.2092082495462], [1.68093582E12, 14.544166778030206]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.68093582E12, "title": "Connect Time Over Time"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getConnectTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average Connect Time in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendConnectTimeOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Average connect time was %y ms"
                }
            };
        },
        createGraph: function () {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesConnectTimeOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotConnectTimeOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewConnectTimeOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Connect Time Over Time
function refreshConnectTimeOverTime(fixTimestamps) {
    var infos = connectTimeOverTimeInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyConnectTimeOverTime");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotConnectTimeOverTime"))) {
        infos.createGraph();
    }else {
        var choiceContainer = $("#choicesConnectTimeOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotConnectTimeOverTime", "#overviewConnectTimeOverTime");
        $('#footerConnectTimeOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var responseTimePercentilesOverTimeInfos = {
        data: {"result": {"minY": 7.0, "minX": 1.68093552E12, "maxY": 43488.0, "series": [{"data": [[1.68093552E12, 9991.0], [1.6809357E12, 17830.0], [1.68093558E12, 43488.0], [1.68093576E12, 16052.0], [1.68093564E12, 38587.0], [1.68093582E12, 11881.0]], "isOverall": false, "label": "Max", "isController": false}, {"data": [[1.68093552E12, 2202.0], [1.6809357E12, 7083.800000000003], [1.68093558E12, 12379.0], [1.68093576E12, 5611.800000000003], [1.68093564E12, 1411.800000000003], [1.68093582E12, 6825.300000000001]], "isOverall": false, "label": "90th percentile", "isController": false}, {"data": [[1.68093552E12, 3581.5999999999985], [1.6809357E12, 9524.920000000013], [1.68093558E12, 39188.5], [1.68093576E12, 8546.680000000051], [1.68093564E12, 11238.990000000002], [1.68093582E12, 9959.239999999998]], "isOverall": false, "label": "99th percentile", "isController": false}, {"data": [[1.68093552E12, 2676.0], [1.6809357E12, 8053.0], [1.68093558E12, 21935.25], [1.68093576E12, 6488.0], [1.68093564E12, 4418.9000000000015], [1.68093582E12, 7665.7499999999945]], "isOverall": false, "label": "95th percentile", "isController": false}, {"data": [[1.68093552E12, 8.0], [1.6809357E12, 8.0], [1.68093558E12, 8.0], [1.68093576E12, 7.0], [1.68093564E12, 8.0], [1.68093582E12, 7.0]], "isOverall": false, "label": "Min", "isController": false}, {"data": [[1.68093552E12, 1090.0], [1.6809357E12, 69.0], [1.68093558E12, 96.0], [1.68093576E12, 121.0], [1.68093564E12, 120.0], [1.68093582E12, 126.0]], "isOverall": false, "label": "Median", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.68093582E12, "title": "Response Time Percentiles Over Time (successful requests only)"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true,
                        fill: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Response Time in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimePercentilesOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Response time was %y ms"
                }
            };
        },
        createGraph: function () {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesResponseTimePercentilesOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimePercentilesOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewResponseTimePercentilesOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Response Time Percentiles Over Time
function refreshResponseTimePercentilesOverTime(fixTimestamps) {
    var infos = responseTimePercentilesOverTimeInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotResponseTimePercentilesOverTime"))) {
        infos.createGraph();
    }else {
        var choiceContainer = $("#choicesResponseTimePercentilesOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimePercentilesOverTime", "#overviewResponseTimePercentilesOverTime");
        $('#footerResponseTimePercentilesOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};


var responseTimeVsRequestInfos = {
    data: {"result": {"minY": 14.0, "minX": 1.0, "maxY": 27190.0, "series": [{"data": [[2.0, 65.5], [3.0, 30.0], [5.0, 36.0], [6.0, 11074.5], [9.0, 17.0], [10.0, 16.0], [14.0, 14.0], [16.0, 20.0], [17.0, 18.5], [21.0, 14.0], [24.0, 20.0], [26.0, 17.0], [29.0, 16.5], [30.0, 14.0], [35.0, 529.0], [34.0, 527.0], [39.0, 517.0], [40.0, 21.0], [45.0, 532.5], [44.0, 20.5], [47.0, 56.0], [51.0, 528.0], [53.0, 25.0], [61.0, 7342.0], [60.0, 8088.0], [65.0, 8532.0], [68.0, 31.5], [74.0, 32.0], [78.0, 33.0], [80.0, 25.0], [86.0, 8870.0], [93.0, 37.0], [92.0, 6145.5], [102.0, 8333.5], [105.0, 58.0], [106.0, 24.0], [108.0, 32.0], [118.0, 32.0], [116.0, 18.0], [125.0, 105.5], [131.0, 1318.0], [133.0, 878.0], [140.0, 27.0], [137.0, 30.0], [138.0, 9414.0], [147.0, 541.0], [145.0, 545.0], [149.0, 9979.0], [158.0, 26.0], [167.0, 39.0], [174.0, 507.5], [171.0, 1373.0], [168.0, 1401.0], [170.0, 988.0], [176.0, 625.5], [182.0, 798.5], [177.0, 1091.0], [178.0, 1017.0], [184.0, 793.0], [185.0, 1102.0], [187.0, 973.0], [188.0, 35.0], [186.0, 27.0], [199.0, 1398.0], [192.0, 1604.0], [196.0, 1390.5], [193.0, 1102.0], [197.0, 731.5], [194.0, 36.5], [200.0, 78.0], [205.0, 777.0], [201.0, 1001.0], [206.0, 1324.5], [207.0, 1208.5], [210.0, 905.0], [211.0, 41.0], [223.0, 1520.0], [219.0, 1380.5], [220.0, 1507.0], [226.0, 1600.5], [230.0, 1570.5], [227.0, 541.0], [233.0, 1232.0], [241.0, 718.0], [243.0, 927.0], [254.0, 1423.0], [269.0, 1295.5], [257.0, 1106.0], [260.0, 1284.5], [289.0, 1481.5], [299.0, 14547.0], [288.0, 546.0], [350.0, 584.0], [341.0, 72.0], [365.0, 211.5], [449.0, 69.0], [523.0, 44.0], [563.0, 174.0], [545.0, 162.0], [633.0, 48.0], [696.0, 59.0], [681.0, 27.0], [680.0, 30.0], [717.0, 45.0], [724.0, 42.0], [735.0, 41.0], [733.0, 39.0], [758.0, 62.0], [789.0, 105.0], [771.0, 52.0], [796.0, 69.0], [801.0, 95.0], [814.0, 50.0], [820.0, 77.5], [817.0, 56.0], [862.0, 52.0], [855.0, 118.0], [853.0, 179.0], [856.0, 152.0], [835.0, 65.0], [844.0, 75.5], [852.0, 59.5], [838.0, 57.0], [861.0, 66.0], [851.0, 40.0], [892.0, 115.0], [876.0, 132.5], [874.0, 118.0], [875.0, 53.0], [872.0, 47.0], [883.0, 101.0], [865.0, 110.0], [878.0, 131.5], [884.0, 123.0], [880.0, 137.0], [881.0, 62.0], [893.0, 83.0], [868.0, 83.0], [888.0, 86.0], [867.0, 77.0], [896.0, 126.0], [927.0, 142.0], [913.0, 131.0], [898.0, 154.5], [901.0, 59.0], [899.0, 72.0], [904.0, 110.0], [906.0, 59.0], [905.0, 62.0], [908.0, 123.0], [907.0, 91.0], [922.0, 103.0], [925.0, 47.0], [926.0, 77.0], [921.0, 57.0], [952.0, 171.5], [946.0, 89.0], [935.0, 170.0], [933.0, 91.0], [932.0, 99.5], [936.0, 127.5], [939.0, 113.0], [943.0, 144.0], [929.0, 96.0], [931.0, 87.0], [950.0, 160.5], [951.0, 274.5], [949.0, 105.0], [948.0, 85.0], [958.0, 119.0], [959.0, 125.0], [955.0, 119.0], [954.0, 119.0], [956.0, 82.0], [986.0, 107.0], [965.0, 102.0], [960.0, 139.0], [977.0, 128.0], [984.0, 135.0], [967.0, 61.0], [989.0, 167.0], [987.0, 101.0], [990.0, 120.0], [976.0, 100.0], [991.0, 153.0], [962.0, 118.0], [964.0, 114.0], [975.0, 139.0], [973.0, 112.0], [968.0, 98.0], [981.0, 157.0], [983.0, 52.0], [1019.0, 119.0], [1021.0, 119.0], [1023.0, 64.0], [1016.0, 113.0], [1000.0, 246.0], [1014.0, 105.0], [1001.0, 130.0], [1008.0, 136.0], [1006.0, 138.0], [1003.0, 64.0], [1029.0, 222.0], [1039.0, 124.0], [1072.0, 69.0], [1044.0, 185.5], [1026.0, 291.5], [1025.0, 164.0], [1042.0, 287.0], [1043.0, 109.0], [1076.0, 226.5], [1066.0, 172.0], [1070.0, 102.0], [1064.0, 115.5], [1084.0, 87.0], [1077.0, 97.0], [1079.0, 132.0], [1063.0, 105.0], [1058.0, 150.0], [1024.0, 128.0], [1051.0, 77.0], [1054.0, 127.0], [1053.0, 175.0], [1034.0, 180.5], [1036.0, 124.0], [1098.0, 162.0], [1147.0, 255.5], [1133.0, 189.0], [1137.0, 147.0], [1105.0, 135.0], [1108.0, 95.5], [1119.0, 103.0], [1088.0, 113.0], [1092.0, 102.0], [1096.0, 109.5], [1095.0, 162.0], [1120.0, 83.0], [1138.0, 123.0], [1131.0, 121.0], [1140.0, 133.0], [1157.0, 115.0], [1.0, 27190.0]], "isOverall": false, "label": "Successes", "isController": false}, {"data": [[3.0, 1013.0], [801.0, 21027.0], [853.0, 21018.5], [856.0, 21029.0], [835.0, 21043.0], [878.0, 21019.0], [880.0, 21017.0], [867.0, 21019.5], [904.0, 21015.0], [908.0, 21011.5], [907.0, 21016.0], [927.0, 21025.0], [948.0, 21021.0], [933.0, 21024.0], [949.0, 21027.0], [958.0, 21022.0], [955.0, 21020.0], [951.0, 21014.0], [956.0, 21024.0], [929.0, 21028.5], [954.0, 21028.0], [965.0, 21020.5], [977.0, 21023.0], [984.0, 21018.0], [986.0, 21025.0], [960.0, 21022.0], [989.0, 21027.0], [962.0, 21027.0], [1021.0, 21021.0], [1016.0, 21022.0], [1000.0, 21021.5], [1014.0, 21018.0], [1001.0, 21021.0], [1039.0, 21024.0], [1029.0, 21031.0], [1042.0, 21025.0], [1024.0, 21021.0], [1034.0, 21028.0], [1064.0, 21028.0], [1098.0, 21028.0], [1147.0, 21035.0], [1133.0, 21014.0], [1137.0, 21027.0], [9.0, 13037.0], [10.0, 1031.5], [16.0, 13042.0], [24.0, 1034.0], [26.0, 1008.0], [29.0, 1006.0], [34.0, 1039.0], [39.0, 1036.5], [45.0, 1039.0], [47.0, 1025.5], [51.0, 1041.0], [93.0, 1044.0], [105.0, 1045.0], [125.0, 1031.0], [140.0, 13081.0], [147.0, 1045.0], [145.0, 1033.0], [170.0, 1026.5], [178.0, 1038.0], [187.0, 1029.0], [193.0, 1033.0], [197.0, 1038.0], [207.0, 1031.0], [201.0, 1036.0], [210.0, 1044.0], [220.0, 1029.0], [227.0, 1057.0], [233.0, 1037.5], [254.0, 1027.0], [257.0, 1023.0], [289.0, 1028.0], [299.0, 1064.0], [288.0, 1036.0], [350.0, 1038.0], [365.0, 1025.5]], "isOverall": false, "label": "Failures", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 1000, "maxX": 1157.0, "title": "Response Time Vs Request"}},
    getOptions: function() {
        return {
            series: {
                lines: {
                    show: false
                },
                points: {
                    show: true
                }
            },
            xaxis: {
                axisLabel: "Global number of requests per second",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            yaxis: {
                axisLabel: "Median Response Time in ms",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            legend: {
                noColumns: 2,
                show: true,
                container: '#legendResponseTimeVsRequest'
            },
            selection: {
                mode: 'xy'
            },
            grid: {
                hoverable: true // IMPORTANT! this is needed for tooltip to work
            },
            tooltip: true,
            tooltipOpts: {
                content: "%s : Median response time at %x req/s was %y ms"
            },
            colors: ["#9ACD32", "#FF6347"]
        };
    },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesResponseTimeVsRequest"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotResponseTimeVsRequest"), dataset, options);
        // setup overview
        $.plot($("#overviewResponseTimeVsRequest"), dataset, prepareOverviewOptions(options));

    }
};

// Response Time vs Request
function refreshResponseTimeVsRequest() {
    var infos = responseTimeVsRequestInfos;
    prepareSeries(infos.data);
    if (isGraph($("#flotResponseTimeVsRequest"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesResponseTimeVsRequest");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimeVsRequest", "#overviewResponseTimeVsRequest");
        $('#footerResponseRimeVsRequest .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};


var latenciesVsRequestInfos = {
    data: {"result": {"minY": 0.0, "minX": 1.0, "maxY": 27190.0, "series": [{"data": [[2.0, 46.0], [3.0, 30.0], [5.0, 36.0], [6.0, 11074.5], [9.0, 17.0], [10.0, 16.0], [14.0, 14.0], [16.0, 20.0], [17.0, 18.5], [21.0, 14.0], [24.0, 20.0], [26.0, 17.0], [29.0, 16.0], [30.0, 14.0], [35.0, 529.0], [34.0, 527.0], [39.0, 517.0], [40.0, 21.0], [45.0, 532.0], [44.0, 20.5], [47.0, 56.0], [51.0, 528.0], [53.0, 25.0], [61.0, 7342.0], [60.0, 8088.0], [65.0, 8532.0], [68.0, 31.5], [74.0, 32.0], [78.0, 33.0], [80.0, 25.0], [86.0, 8870.0], [93.0, 37.0], [92.0, 6145.5], [102.0, 8333.5], [105.0, 58.0], [106.0, 24.0], [108.0, 32.0], [118.0, 32.0], [116.0, 18.0], [125.0, 105.5], [131.0, 1318.0], [133.0, 878.0], [140.0, 27.0], [137.0, 30.0], [138.0, 9414.0], [147.0, 541.0], [145.0, 545.0], [149.0, 9979.0], [158.0, 26.0], [167.0, 39.0], [174.0, 507.5], [171.0, 1373.0], [168.0, 1401.0], [170.0, 987.5], [176.0, 625.5], [182.0, 798.5], [177.0, 1091.0], [178.0, 1017.0], [184.0, 793.0], [185.0, 1102.0], [187.0, 973.0], [188.0, 35.0], [186.0, 27.0], [199.0, 1398.0], [192.0, 1604.0], [196.0, 1390.5], [193.0, 1102.0], [197.0, 731.5], [194.0, 36.5], [200.0, 78.0], [205.0, 777.0], [201.0, 1001.0], [206.0, 1324.5], [207.0, 1208.5], [210.0, 905.0], [211.0, 41.0], [223.0, 1520.0], [219.0, 1380.5], [220.0, 1507.0], [226.0, 1600.5], [230.0, 1570.5], [227.0, 541.0], [233.0, 1232.0], [241.0, 718.0], [243.0, 927.0], [254.0, 1423.0], [269.0, 1295.5], [257.0, 1106.0], [260.0, 1284.5], [289.0, 1481.5], [299.0, 14547.0], [288.0, 546.0], [350.0, 584.0], [341.0, 72.0], [365.0, 211.5], [449.0, 69.0], [523.0, 44.0], [563.0, 174.0], [545.0, 162.0], [633.0, 48.0], [696.0, 59.0], [681.0, 27.0], [680.0, 30.0], [717.0, 45.0], [724.0, 42.0], [735.0, 41.0], [733.0, 39.0], [758.0, 62.0], [789.0, 105.0], [771.0, 52.0], [796.0, 69.0], [801.0, 95.0], [814.0, 50.0], [820.0, 77.5], [817.0, 56.0], [862.0, 52.0], [855.0, 118.0], [853.0, 179.0], [856.0, 152.0], [835.0, 65.0], [844.0, 75.5], [852.0, 59.5], [838.0, 57.0], [861.0, 66.0], [851.0, 40.0], [892.0, 115.0], [876.0, 132.5], [874.0, 118.0], [875.0, 53.0], [872.0, 47.0], [883.0, 101.0], [865.0, 110.0], [878.0, 131.5], [884.0, 123.0], [880.0, 137.0], [881.0, 62.0], [893.0, 83.0], [868.0, 83.0], [888.0, 86.0], [867.0, 77.0], [896.0, 126.0], [927.0, 142.0], [913.0, 131.0], [898.0, 154.5], [901.0, 59.0], [899.0, 72.0], [904.0, 110.0], [906.0, 59.0], [905.0, 62.0], [908.0, 123.0], [907.0, 91.0], [922.0, 103.0], [925.0, 47.0], [926.0, 77.0], [921.0, 57.0], [952.0, 171.5], [946.0, 89.0], [935.0, 170.0], [933.0, 91.0], [932.0, 99.5], [936.0, 127.5], [939.0, 113.0], [943.0, 143.0], [929.0, 96.0], [931.0, 87.0], [950.0, 160.5], [951.0, 274.5], [949.0, 105.0], [948.0, 85.0], [958.0, 119.0], [959.0, 125.0], [955.0, 119.0], [954.0, 119.0], [956.0, 82.0], [986.0, 107.0], [965.0, 102.0], [960.0, 139.0], [977.0, 128.0], [984.0, 135.0], [967.0, 61.0], [989.0, 167.0], [987.0, 101.0], [990.0, 120.0], [976.0, 100.0], [991.0, 153.0], [962.0, 118.0], [964.0, 114.0], [975.0, 139.0], [973.0, 112.0], [968.0, 98.0], [981.0, 157.0], [983.0, 52.0], [1019.0, 119.0], [1021.0, 119.0], [1023.0, 64.0], [1016.0, 113.0], [1000.0, 246.0], [1014.0, 105.0], [1001.0, 130.0], [1008.0, 136.0], [1006.0, 138.0], [1003.0, 64.0], [1029.0, 222.0], [1039.0, 124.0], [1072.0, 69.0], [1044.0, 185.5], [1026.0, 291.0], [1025.0, 164.0], [1042.0, 287.0], [1043.0, 109.0], [1076.0, 226.5], [1066.0, 172.0], [1070.0, 102.0], [1064.0, 115.5], [1084.0, 87.0], [1077.0, 97.0], [1079.0, 132.0], [1063.0, 105.0], [1058.0, 150.0], [1024.0, 128.0], [1051.0, 77.0], [1054.0, 127.0], [1053.0, 175.0], [1034.0, 180.5], [1036.0, 124.0], [1098.0, 162.0], [1147.0, 255.5], [1133.0, 189.0], [1137.0, 147.0], [1105.0, 135.0], [1108.0, 95.5], [1119.0, 103.0], [1088.0, 113.0], [1092.0, 102.0], [1096.0, 109.5], [1095.0, 162.0], [1120.0, 83.0], [1138.0, 123.0], [1131.0, 121.0], [1140.0, 132.5], [1157.0, 115.0], [1.0, 27190.0]], "isOverall": false, "label": "Successes", "isController": false}, {"data": [[3.0, 0.0], [801.0, 0.0], [853.0, 0.0], [856.0, 0.0], [835.0, 0.0], [878.0, 0.0], [880.0, 0.0], [867.0, 0.0], [904.0, 0.0], [908.0, 0.0], [907.0, 0.0], [927.0, 0.0], [948.0, 0.0], [933.0, 0.0], [949.0, 0.0], [958.0, 0.0], [955.0, 0.0], [951.0, 0.0], [956.0, 0.0], [929.0, 0.0], [954.0, 0.0], [965.0, 0.0], [977.0, 0.0], [984.0, 0.0], [986.0, 0.0], [960.0, 0.0], [989.0, 0.0], [962.0, 0.0], [1021.0, 0.0], [1016.0, 0.0], [1000.0, 0.0], [1014.0, 0.0], [1001.0, 0.0], [1039.0, 0.0], [1029.0, 0.0], [1042.0, 0.0], [1024.0, 0.0], [1034.0, 0.0], [1064.0, 0.0], [1098.0, 0.0], [1147.0, 0.0], [1133.0, 0.0], [1137.0, 0.0], [9.0, 0.0], [10.0, 0.0], [16.0, 0.0], [24.0, 0.0], [26.0, 0.0], [29.0, 0.0], [34.0, 0.0], [39.0, 0.0], [45.0, 0.0], [47.0, 0.0], [51.0, 0.0], [93.0, 0.0], [105.0, 0.0], [125.0, 0.0], [140.0, 0.0], [147.0, 0.0], [145.0, 0.0], [170.0, 0.0], [178.0, 0.0], [187.0, 0.0], [193.0, 0.0], [197.0, 0.0], [207.0, 0.0], [201.0, 0.0], [210.0, 0.0], [220.0, 0.0], [227.0, 0.0], [233.0, 0.0], [254.0, 0.0], [257.0, 0.0], [289.0, 0.0], [299.0, 0.0], [288.0, 0.0], [350.0, 0.0], [365.0, 0.0]], "isOverall": false, "label": "Failures", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 1000, "maxX": 1157.0, "title": "Latencies Vs Request"}},
    getOptions: function() {
        return{
            series: {
                lines: {
                    show: false
                },
                points: {
                    show: true
                }
            },
            xaxis: {
                axisLabel: "Global number of requests per second",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            yaxis: {
                axisLabel: "Median Latency in ms",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            legend: { noColumns: 2,show: true, container: '#legendLatencyVsRequest' },
            selection: {
                mode: 'xy'
            },
            grid: {
                hoverable: true // IMPORTANT! this is needed for tooltip to work
            },
            tooltip: true,
            tooltipOpts: {
                content: "%s : Median Latency time at %x req/s was %y ms"
            },
            colors: ["#9ACD32", "#FF6347"]
        };
    },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesLatencyVsRequest"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotLatenciesVsRequest"), dataset, options);
        // setup overview
        $.plot($("#overviewLatenciesVsRequest"), dataset, prepareOverviewOptions(options));
    }
};

// Latencies vs Request
function refreshLatenciesVsRequest() {
        var infos = latenciesVsRequestInfos;
        prepareSeries(infos.data);
        if(isGraph($("#flotLatenciesVsRequest"))){
            infos.createGraph();
        }else{
            var choiceContainer = $("#choicesLatencyVsRequest");
            createLegend(choiceContainer, infos);
            infos.createGraph();
            setGraphZoomable("#flotLatenciesVsRequest", "#overviewLatenciesVsRequest");
            $('#footerLatenciesVsRequest .legendColorBox > div').each(function(i){
                $(this).clone().prependTo(choiceContainer.find("li").eq(i));
            });
        }
};

var hitsPerSecondInfos = {
        data: {"result": {"minY": 113.23333333333333, "minX": 1.68093552E12, "maxY": 956.1166666666667, "series": [{"data": [[1.68093552E12, 160.46666666666667], [1.6809357E12, 943.8833333333333], [1.68093558E12, 113.23333333333333], [1.68093576E12, 956.1166666666667], [1.68093564E12, 719.4333333333333], [1.68093582E12, 232.76666666666668]], "isOverall": false, "label": "hitsPerSecond", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.68093582E12, "title": "Hits Per Second"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of hits / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendHitsPerSecond"
                },
                selection: {
                    mode : 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y.2 hits/sec"
                }
            };
        },
        createGraph: function createGraph() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesHitsPerSecond"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotHitsPerSecond"), dataset, options);
            // setup overview
            $.plot($("#overviewHitsPerSecond"), dataset, prepareOverviewOptions(options));
        }
};

// Hits per second
function refreshHitsPerSecond(fixTimestamps) {
    var infos = hitsPerSecondInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if (isGraph($("#flotHitsPerSecond"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesHitsPerSecond");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotHitsPerSecond", "#overviewHitsPerSecond");
        $('#footerHitsPerSecond .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
}

var codesPerSecondInfos = {
        data: {"result": {"minY": 1.5, "minX": 1.68093552E12, "maxY": 956.1, "series": [{"data": [[1.68093552E12, 153.65], [1.6809357E12, 934.7666666666667], [1.68093558E12, 106.73333333333333], [1.68093576E12, 956.1], [1.68093564E12, 707.3166666666667], [1.68093582E12, 249.43333333333334]], "isOverall": false, "label": "200", "isController": false}, {"data": [[1.68093552E12, 1.8166666666666667], [1.6809357E12, 9.133333333333333], [1.68093558E12, 1.5], [1.68093564E12, 5.45]], "isOverall": false, "label": "Non HTTP response code: org.apache.http.conn.HttpHostConnectException", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.68093582E12, "title": "Codes Per Second"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of responses / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendCodesPerSecond"
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "Number of Response Codes %s at %x was %y.2 responses / sec"
                }
            };
        },
    createGraph: function() {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesCodesPerSecond"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotCodesPerSecond"), dataset, options);
        // setup overview
        $.plot($("#overviewCodesPerSecond"), dataset, prepareOverviewOptions(options));
    }
};

// Codes per second
function refreshCodesPerSecond(fixTimestamps) {
    var infos = codesPerSecondInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotCodesPerSecond"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesCodesPerSecond");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotCodesPerSecond", "#overviewCodesPerSecond");
        $('#footerCodesPerSecond .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var transactionsPerSecondInfos = {
        data: {"result": {"minY": 1.5, "minX": 1.68093552E12, "maxY": 956.1, "series": [{"data": [[1.68093552E12, 153.65], [1.6809357E12, 934.7666666666667], [1.68093558E12, 106.73333333333333], [1.68093576E12, 956.1], [1.68093564E12, 707.3166666666667], [1.68093582E12, 249.43333333333334]], "isOverall": false, "label": "HTTP Request-success", "isController": false}, {"data": [[1.68093552E12, 1.8166666666666667], [1.6809357E12, 9.133333333333333], [1.68093558E12, 1.5], [1.68093564E12, 5.45]], "isOverall": false, "label": "HTTP Request-failure", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.68093582E12, "title": "Transactions Per Second"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of transactions / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendTransactionsPerSecond"
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y transactions / sec"
                }
            };
        },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesTransactionsPerSecond"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotTransactionsPerSecond"), dataset, options);
        // setup overview
        $.plot($("#overviewTransactionsPerSecond"), dataset, prepareOverviewOptions(options));
    }
};

// Transactions per second
function refreshTransactionsPerSecond(fixTimestamps) {
    var infos = transactionsPerSecondInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyTransactionsPerSecond");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotTransactionsPerSecond"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesTransactionsPerSecond");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotTransactionsPerSecond", "#overviewTransactionsPerSecond");
        $('#footerTransactionsPerSecond .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var totalTPSInfos = {
        data: {"result": {"minY": 1.5, "minX": 1.68093552E12, "maxY": 956.1, "series": [{"data": [[1.68093552E12, 153.65], [1.6809357E12, 934.7666666666667], [1.68093558E12, 106.73333333333333], [1.68093576E12, 956.1], [1.68093564E12, 707.3166666666667], [1.68093582E12, 249.43333333333334]], "isOverall": false, "label": "Transaction-success", "isController": false}, {"data": [[1.68093552E12, 1.8166666666666667], [1.6809357E12, 9.133333333333333], [1.68093558E12, 1.5], [1.68093564E12, 5.45]], "isOverall": false, "label": "Transaction-failure", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.68093582E12, "title": "Total Transactions Per Second"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of transactions / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendTotalTPS"
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y transactions / sec"
                },
                colors: ["#9ACD32", "#FF6347"]
            };
        },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesTotalTPS"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotTotalTPS"), dataset, options);
        // setup overview
        $.plot($("#overviewTotalTPS"), dataset, prepareOverviewOptions(options));
    }
};

// Total Transactions per second
function refreshTotalTPS(fixTimestamps) {
    var infos = totalTPSInfos;
    // We want to ignore seriesFilter
    prepareSeries(infos.data, false, true);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotTotalTPS"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesTotalTPS");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotTotalTPS", "#overviewTotalTPS");
        $('#footerTotalTPS .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

// Collapse the graph matching the specified DOM element depending the collapsed
// status
function collapse(elem, collapsed){
    if(collapsed){
        $(elem).parent().find(".fa-chevron-up").removeClass("fa-chevron-up").addClass("fa-chevron-down");
    } else {
        $(elem).parent().find(".fa-chevron-down").removeClass("fa-chevron-down").addClass("fa-chevron-up");
        if (elem.id == "bodyBytesThroughputOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshBytesThroughputOverTime(true);
            }
            document.location.href="#bytesThroughputOverTime";
        } else if (elem.id == "bodyLatenciesOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshLatenciesOverTime(true);
            }
            document.location.href="#latenciesOverTime";
        } else if (elem.id == "bodyCustomGraph") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshCustomGraph(true);
            }
            document.location.href="#responseCustomGraph";
        } else if (elem.id == "bodyConnectTimeOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshConnectTimeOverTime(true);
            }
            document.location.href="#connectTimeOverTime";
        } else if (elem.id == "bodyResponseTimePercentilesOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshResponseTimePercentilesOverTime(true);
            }
            document.location.href="#responseTimePercentilesOverTime";
        } else if (elem.id == "bodyResponseTimeDistribution") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshResponseTimeDistribution();
            }
            document.location.href="#responseTimeDistribution" ;
        } else if (elem.id == "bodySyntheticResponseTimeDistribution") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshSyntheticResponseTimeDistribution();
            }
            document.location.href="#syntheticResponseTimeDistribution" ;
        } else if (elem.id == "bodyActiveThreadsOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshActiveThreadsOverTime(true);
            }
            document.location.href="#activeThreadsOverTime";
        } else if (elem.id == "bodyTimeVsThreads") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshTimeVsThreads();
            }
            document.location.href="#timeVsThreads" ;
        } else if (elem.id == "bodyCodesPerSecond") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshCodesPerSecond(true);
            }
            document.location.href="#codesPerSecond";
        } else if (elem.id == "bodyTransactionsPerSecond") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshTransactionsPerSecond(true);
            }
            document.location.href="#transactionsPerSecond";
        } else if (elem.id == "bodyTotalTPS") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshTotalTPS(true);
            }
            document.location.href="#totalTPS";
        } else if (elem.id == "bodyResponseTimeVsRequest") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshResponseTimeVsRequest();
            }
            document.location.href="#responseTimeVsRequest";
        } else if (elem.id == "bodyLatenciesVsRequest") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshLatenciesVsRequest();
            }
            document.location.href="#latencyVsRequest";
        }
    }
}

/*
 * Activates or deactivates all series of the specified graph (represented by id parameter)
 * depending on checked argument.
 */
function toggleAll(id, checked){
    var placeholder = document.getElementById(id);

    var cases = $(placeholder).find(':checkbox');
    cases.prop('checked', checked);
    $(cases).parent().children().children().toggleClass("legend-disabled", !checked);

    var choiceContainer;
    if ( id == "choicesBytesThroughputOverTime"){
        choiceContainer = $("#choicesBytesThroughputOverTime");
        refreshBytesThroughputOverTime(false);
    } else if(id == "choicesResponseTimesOverTime"){
        choiceContainer = $("#choicesResponseTimesOverTime");
        refreshResponseTimeOverTime(false);
    }else if(id == "choicesResponseCustomGraph"){
        choiceContainer = $("#choicesResponseCustomGraph");
        refreshCustomGraph(false);
    } else if ( id == "choicesLatenciesOverTime"){
        choiceContainer = $("#choicesLatenciesOverTime");
        refreshLatenciesOverTime(false);
    } else if ( id == "choicesConnectTimeOverTime"){
        choiceContainer = $("#choicesConnectTimeOverTime");
        refreshConnectTimeOverTime(false);
    } else if ( id == "choicesResponseTimePercentilesOverTime"){
        choiceContainer = $("#choicesResponseTimePercentilesOverTime");
        refreshResponseTimePercentilesOverTime(false);
    } else if ( id == "choicesResponseTimePercentiles"){
        choiceContainer = $("#choicesResponseTimePercentiles");
        refreshResponseTimePercentiles();
    } else if(id == "choicesActiveThreadsOverTime"){
        choiceContainer = $("#choicesActiveThreadsOverTime");
        refreshActiveThreadsOverTime(false);
    } else if ( id == "choicesTimeVsThreads"){
        choiceContainer = $("#choicesTimeVsThreads");
        refreshTimeVsThreads();
    } else if ( id == "choicesSyntheticResponseTimeDistribution"){
        choiceContainer = $("#choicesSyntheticResponseTimeDistribution");
        refreshSyntheticResponseTimeDistribution();
    } else if ( id == "choicesResponseTimeDistribution"){
        choiceContainer = $("#choicesResponseTimeDistribution");
        refreshResponseTimeDistribution();
    } else if ( id == "choicesHitsPerSecond"){
        choiceContainer = $("#choicesHitsPerSecond");
        refreshHitsPerSecond(false);
    } else if(id == "choicesCodesPerSecond"){
        choiceContainer = $("#choicesCodesPerSecond");
        refreshCodesPerSecond(false);
    } else if ( id == "choicesTransactionsPerSecond"){
        choiceContainer = $("#choicesTransactionsPerSecond");
        refreshTransactionsPerSecond(false);
    } else if ( id == "choicesTotalTPS"){
        choiceContainer = $("#choicesTotalTPS");
        refreshTotalTPS(false);
    } else if ( id == "choicesResponseTimeVsRequest"){
        choiceContainer = $("#choicesResponseTimeVsRequest");
        refreshResponseTimeVsRequest();
    } else if ( id == "choicesLatencyVsRequest"){
        choiceContainer = $("#choicesLatencyVsRequest");
        refreshLatenciesVsRequest();
    }
    var color = checked ? "black" : "#818181";
    if(choiceContainer != null) {
        choiceContainer.find("label").each(function(){
            this.style.color = color;
        });
    }
}

